/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.core.DataTypeConverters;
import org.komapper.core.spi.DataTypeConverter;
import org.komapper.jdbc.EmptyJdbcDataTypeProvider;
import org.komapper.jdbc.JdbcDataType;
import org.komapper.jdbc.JdbcDataTypeProvider;
import org.komapper.jdbc.JdbcDataTypeProxy;
import org.komapper.jdbc.JdbcUserDefinedDataTypeProvider;
import org.komapper.jdbc.spi.JdbcDataTypeProviderFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\b"}, d2={"Lorg/komapper/jdbc/JdbcDataTypeProviders;", "", "()V", "get", "Lorg/komapper/jdbc/JdbcDataTypeProvider;", "driver", "", "firstProvider", "komapper-jdbc"})
public final class JdbcDataTypeProviders {
    @NotNull
    public static final JdbcDataTypeProviders INSTANCE = new JdbcDataTypeProviders();

    private JdbcDataTypeProviders() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JdbcDataTypeProvider get(@NotNull String driver, @Nullable JdbcDataTypeProvider firstProvider) {
        void $this$associateByTo$iv$iv;
        Iterable factory;
        void $this$sortedBy$iv;
        JdbcDataTypeProviderFactory it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        ServiceLoader<JdbcDataTypeProviderFactory> loader = ServiceLoader.load(JdbcDataTypeProviderFactory.class);
        Intrinsics.checkNotNullExpressionValue(loader, (String)"loader");
        Iterable $this$filter$iv = loader;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JdbcDataTypeProviderFactory)element$iv$iv;
            boolean bl = false;
            if (!it.supports(driver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List factories = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JdbcDataTypeProviderFactory it = (JdbcDataTypeProviderFactory)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (JdbcDataTypeProviderFactory)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
        JdbcDataTypeProvider lastProvider = EmptyJdbcDataTypeProvider.INSTANCE;
        Iterable $this$fold$iv = factories;
        boolean $i$f$fold = false;
        JdbcDataTypeProvider accumulator$iv = lastProvider;
        for (Object element$iv : $this$fold$iv) {
            it = (JdbcDataTypeProviderFactory)element$iv;
            JdbcDataTypeProvider acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = factory.create(acc);
        }
        JdbcDataTypeProvider chainedProviders = accumulator$iv;
        JdbcUserDefinedDataTypeProvider secondProvider = JdbcUserDefinedDataTypeProvider.INSTANCE;
        Iterable $this$associateBy$iv = DataTypeConverters.INSTANCE.get();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        factory = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            DataTypeConverter dataTypeConverter = (DataTypeConverter)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            map.put(it2.getExteriorClass(), element$iv$iv);
        }
        Map converters = destination$iv$iv2;
        return new JdbcDataTypeProvider(converters, firstProvider, secondProvider, chainedProviders){
            final /* synthetic */ Map<KClass<? extends Object>, DataTypeConverter<?, ?>> $converters;
            final /* synthetic */ JdbcDataTypeProvider $firstProvider;
            final /* synthetic */ JdbcUserDefinedDataTypeProvider $secondProvider;
            final /* synthetic */ JdbcDataTypeProvider $chainedProviders;
            {
                this.$converters = $converters;
                this.$firstProvider = $firstProvider;
                this.$secondProvider = $secondProvider;
                this.$chainedProviders = $chainedProviders;
            }

            @Nullable
            public <T> JdbcDataType<T> get(@NotNull KClass<? extends T> klass) {
                JdbcDataType jdbcDataType;
                Intrinsics.checkNotNullParameter(klass, (String)"klass");
                DataTypeConverter<?, ?> converter = this.$converters.get(klass);
                if (converter == null) {
                    jdbcDataType = this.find(klass);
                } else {
                    JdbcDataType<T> jdbcDataType2 = this.find(converter.getInteriorClass());
                    if (jdbcDataType2 == null) {
                        throw new IllegalStateException(("The dataType is not found for the type \"" + converter.getInteriorClass().getQualifiedName() + "\".").toString());
                    }
                    JdbcDataType<T> dataType = jdbcDataType2;
                    jdbcDataType = new JdbcDataTypeProxy<?, ?>(converter, dataType);
                }
                return jdbcDataType;
            }

            private final <T> JdbcDataType<T> find(KClass<? extends T> klass) {
                Object object = this.$firstProvider;
                if ((object == null || (object = object.get(klass)) == null) && (object = this.$secondProvider.get(klass)) == null) {
                    object = this.$chainedProviders.get(klass);
                }
                return object;
            }
        };
    }

    public static /* synthetic */ JdbcDataTypeProvider get$default(JdbcDataTypeProviders jdbcDataTypeProviders, String string, JdbcDataTypeProvider jdbcDataTypeProvider, int n, Object object) {
        if ((n & 2) != 0) {
            jdbcDataTypeProvider = null;
        }
        return jdbcDataTypeProviders.get(string, jdbcDataTypeProvider);
    }
}

