/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.core.spi.DataTypeConverter;
import org.komapper.jdbc.JdbcDataType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B'\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001cJ'\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0017\u0010#\u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010$R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/komapper/jdbc/JdbcDataTypeProxy;", "EXTERIOR", "", "INTERIOR", "Lorg/komapper/jdbc/JdbcDataType;", "converter", "Lorg/komapper/core/spi/DataTypeConverter;", "dataType", "(Lorg/komapper/core/spi/DataTypeConverter;Lorg/komapper/jdbc/JdbcDataType;)V", "jdbcType", "Ljava/sql/JDBCType;", "getJdbcType", "()Ljava/sql/JDBCType;", "klass", "Lkotlin/reflect/KClass;", "getKlass", "()Lkotlin/reflect/KClass;", "name", "", "getName", "()Ljava/lang/String;", "getValue", "rs", "Ljava/sql/ResultSet;", "index", "", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "columnLabel", "(Ljava/sql/ResultSet;Ljava/lang/String;)Ljava/lang/Object;", "setValue", "", "ps", "Ljava/sql/PreparedStatement;", "value", "(Ljava/sql/PreparedStatement;ILjava/lang/Object;)V", "toString", "(Ljava/lang/Object;)Ljava/lang/String;", "komapper-jdbc"})
public final class JdbcDataTypeProxy<EXTERIOR, INTERIOR>
implements JdbcDataType<EXTERIOR> {
    @NotNull
    private final DataTypeConverter<EXTERIOR, INTERIOR> converter;
    @NotNull
    private final JdbcDataType<INTERIOR> dataType;

    public JdbcDataTypeProxy(@NotNull DataTypeConverter<EXTERIOR, INTERIOR> converter, @NotNull JdbcDataType<INTERIOR> dataType) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        Intrinsics.checkNotNullParameter(dataType, (String)"dataType");
        this.converter = converter;
        this.dataType = dataType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.dataType.getName();
    }

    @Override
    @NotNull
    public KClass<EXTERIOR> getKlass() {
        return this.converter.getExteriorClass();
    }

    @Override
    @NotNull
    public JDBCType getJdbcType() {
        return this.dataType.getJdbcType();
    }

    @Override
    @Nullable
    public EXTERIOR getValue(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        INTERIOR value = this.dataType.getValue(rs, index);
        return (EXTERIOR)(rs.wasNull() || value == null ? null : this.converter.wrap(value));
    }

    @Override
    @Nullable
    public EXTERIOR getValue(@NotNull ResultSet rs, @NotNull String columnLabel) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)columnLabel, (String)"columnLabel");
        INTERIOR value = this.dataType.getValue(rs, columnLabel);
        return (EXTERIOR)(rs.wasNull() || value == null ? null : this.converter.wrap(value));
    }

    @Override
    public void setValue(@NotNull PreparedStatement ps, int index, @Nullable EXTERIOR value) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        if (value == null) {
            Integer n = this.dataType.getJdbcType().getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"dataType.jdbcType.vendorTypeNumber");
            ps.setNull(index, ((Number)n).intValue());
        } else {
            this.dataType.setValue(ps, index, this.converter.unwrap(value));
        }
    }

    @Override
    @NotNull
    public String toString(@Nullable EXTERIOR value) {
        return value == null ? "null" : this.dataType.toString(this.converter.unwrap(value));
    }
}

