/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.spi.SpiUtilityKt;
import org.komapper.jdbc.JdbcDialect;
import org.komapper.jdbc.spi.JdbcDialectFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/komapper/jdbc/JdbcDialects;", "", "()V", "jdbcUrlPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "extractJdbcDriver", "", "url", "get", "Lorg/komapper/jdbc/JdbcDialect;", "driver", "getByUrl", "komapper-jdbc"})
public final class JdbcDialects {
    @NotNull
    public static final JdbcDialects INSTANCE = new JdbcDialects();
    private static final Pattern jdbcUrlPattern = Pattern.compile("^jdbc:(tc:)?([^:]*):.*");

    private JdbcDialects() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JdbcDialect get(@NotNull String driver) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        ServiceLoader<JdbcDialectFactory> loader = ServiceLoader.load(JdbcDialectFactory.class);
        Intrinsics.checkNotNullExpressionValue(loader, (String)"loader");
        Iterable $this$filter$iv = loader;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JdbcDialectFactory it = (JdbcDialectFactory)element$iv$iv;
            boolean bl = false;
            if (!it.supports(driver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        JdbcDialectFactory jdbcDialectFactory = (JdbcDialectFactory)SpiUtilityKt.findByPriority((Iterable)((List)destination$iv$iv));
        if (jdbcDialectFactory == null) {
            throw new IllegalStateException(("The dialect is not found for the JDBC url. Try to add the 'komapper-dialect-" + driver + "-jdbc' dependency. driver='" + driver + "'").toString());
        }
        JdbcDialectFactory factory = jdbcDialectFactory;
        return factory.create();
    }

    @NotNull
    public final JdbcDialect getByUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String driver = this.extractJdbcDriver(url);
        return this.get(driver);
    }

    @NotNull
    public final String extractJdbcDriver(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Matcher matcher = jdbcUrlPattern.matcher(url);
        if (matcher.matches()) {
            String string = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(2)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string2;
        }
        throw new IllegalStateException(("The driver in the JDBC URL is not found. url=" + url).toString());
    }
}

