/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.core.ExecutionOptions;
import org.komapper.core.ExecutionOptionsProvider;
import org.komapper.core.StatementPart;
import org.komapper.core.UniqueConstraintException;
import org.komapper.core.Value;
import org.komapper.jdbc.JdbcDataOperator;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcDialect;
import org.komapper.jdbc.JdbcException;
import org.komapper.jdbc.JdbcExecutor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016J(\u0010\u0018\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00190\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014Jf\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001c2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u001d0\u001f2(\u0010\"\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0#\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0$\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J<\u0010\u001b\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\f\u001a\u00020\r2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u0002H\u001d0\u0016\u00a2\u0006\u0002\u0010)J \u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00140\u00192\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010,\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u0002002\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010\f\u001a\u000202H\u0002J!\u00103\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H\u001d05H\u0002\u00a2\u0006\u0002\u00106R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lorg/komapper/jdbc/JdbcExecutor;", "", "config", "Lorg/komapper/jdbc/JdbcDatabaseConfig;", "executionOptionProvider", "Lorg/komapper/core/ExecutionOptionsProvider;", "generatedColumn", "", "(Lorg/komapper/jdbc/JdbcDatabaseConfig;Lorg/komapper/core/ExecutionOptionsProvider;Ljava/lang/String;)V", "executionOptions", "Lorg/komapper/core/ExecutionOptions;", "asSql", "statement", "Lorg/komapper/core/Statement;", "bind", "", "ps", "Ljava/sql/PreparedStatement;", "execute", "statements", "", "handler", "Lkotlin/Function1;", "Ljava/sql/SQLException;", "executeBatch", "Lkotlin/Pair;", "", "executeQuery", "R", "T", "transform", "Lkotlin/Function2;", "Lorg/komapper/jdbc/JdbcDataOperator;", "Ljava/sql/ResultSet;", "collect", "Lkotlinx/coroutines/flow/Flow;", "Lkotlin/coroutines/Continuation;", "(Lorg/komapper/core/Statement;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Lkotlin/ParameterName;", "name", "rs", "(Lorg/komapper/core/Statement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "executeUpdate", "fetchGeneratedKeys", "inspect", "log", "prepare", "con", "Ljava/sql/Connection;", "setUp", "Ljava/sql/Statement;", "withExceptionTranslator", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "komapper-jdbc"})
public final class JdbcExecutor {
    @NotNull
    private final JdbcDatabaseConfig config;
    @Nullable
    private final String generatedColumn;
    @NotNull
    private final ExecutionOptions executionOptions;

    public JdbcExecutor(@NotNull JdbcDatabaseConfig config, @NotNull ExecutionOptionsProvider executionOptionProvider, @Nullable String generatedColumn) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)executionOptionProvider, (String)"executionOptionProvider");
        this.config = config;
        this.generatedColumn = generatedColumn;
        this.executionOptions = this.config.getExecutionOptions().plus(executionOptionProvider.getExecutionOptions());
    }

    public /* synthetic */ JdbcExecutor(JdbcDatabaseConfig jdbcDatabaseConfig, ExecutionOptionsProvider executionOptionsProvider, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(jdbcDatabaseConfig, executionOptionsProvider, string);
    }

    public final <T> T executeQuery(@NotNull org.komapper.core.Statement statement, @NotNull Function1<? super ResultSet, ? extends T> transform) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return this.withExceptionTranslator((Function0)new Function0<T>(this, statement, transform){
            final /* synthetic */ JdbcExecutor this$0;
            final /* synthetic */ org.komapper.core.Statement $statement;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            {
                this.this$0 = $receiver;
                this.$statement = $statement;
                this.$transform = $transform;
                super(0);
            }

            public final T invoke() {
                org.komapper.core.Statement statement = JdbcExecutor.access$inspect(this.this$0, this.$statement);
                return (T)JdbcExecutor.access$getConfig$p(this.this$0).getSession().useConnection((Function1)new Function1<Connection, T>(this.this$0, statement, this.$transform){
                    final /* synthetic */ JdbcExecutor this$0;
                    final /* synthetic */ org.komapper.core.Statement $statement;
                    final /* synthetic */ Function1<ResultSet, T> $transform;
                    {
                        this.this$0 = $receiver;
                        this.$statement = $statement;
                        this.$transform = $transform;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final T invoke(@NotNull Connection con) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                        AutoCloseable autoCloseable = JdbcExecutor.access$prepare(this.this$0, con, this.$statement);
                        JdbcExecutor jdbcExecutor = this.this$0;
                        org.komapper.core.Statement statement = this.$statement;
                        Function1<ResultSet, T> function1 = this.$transform;
                        Throwable throwable = null;
                        try {
                            Object object2;
                            PreparedStatement ps = (PreparedStatement)autoCloseable;
                            boolean bl = false;
                            JdbcExecutor.access$setUp(jdbcExecutor, ps);
                            JdbcExecutor.access$log(jdbcExecutor, statement);
                            JdbcExecutor.access$bind(jdbcExecutor, ps, statement);
                            AutoCloseable autoCloseable2 = ps.executeQuery();
                            Throwable throwable2 = null;
                            try {
                                ResultSet rs = (ResultSet)autoCloseable2;
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
                                object2 = function1.invoke((Object)rs);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            object = object2;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return (T)object;
                    }
                });
            }
        });
    }

    public final <T, R> R executeQuery(@NotNull org.komapper.core.Statement statement, @NotNull Function2<? super JdbcDataOperator, ? super ResultSet, ? extends T> transform, @NotNull Function2<? super Flow<? extends T>, ? super Continuation<? super R>, ? extends Object> collect) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Intrinsics.checkNotNullParameter(collect, (String)"collect");
        return (R)this.withExceptionTranslator((Function0)new Function0<R>(this, statement, transform, collect){
            final /* synthetic */ JdbcExecutor this$0;
            final /* synthetic */ org.komapper.core.Statement $statement;
            final /* synthetic */ Function2<JdbcDataOperator, ResultSet, T> $transform;
            final /* synthetic */ Function2<Flow<? extends T>, Continuation<? super R>, Object> $collect;
            {
                this.this$0 = $receiver;
                this.$statement = $statement;
                this.$transform = $transform;
                this.$collect = $collect;
                super(0);
            }

            public final R invoke() {
                org.komapper.core.Statement statement = JdbcExecutor.access$inspect(this.this$0, this.$statement);
                return JdbcExecutor.access$getConfig$p(this.this$0).getSession().useConnection((Function1)new Function1<Connection, R>(this.this$0, statement, this.$transform, this.$collect){
                    final /* synthetic */ JdbcExecutor this$0;
                    final /* synthetic */ org.komapper.core.Statement $statement;
                    final /* synthetic */ Function2<JdbcDataOperator, ResultSet, T> $transform;
                    final /* synthetic */ Function2<Flow<? extends T>, Continuation<? super R>, Object> $collect;
                    {
                        this.this$0 = $receiver;
                        this.$statement = $statement;
                        this.$transform = $transform;
                        this.$collect = $collect;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final R invoke(@NotNull Connection con) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                        AutoCloseable autoCloseable = JdbcExecutor.access$prepare(this.this$0, con, this.$statement);
                        JdbcExecutor jdbcExecutor = this.this$0;
                        org.komapper.core.Statement statement = this.$statement;
                        Function2<JdbcDataOperator, ResultSet, T> function2 = this.$transform;
                        Function2<Flow<? extends T>, Continuation<? super R>, Object> function22 = this.$collect;
                        Throwable throwable = null;
                        try {
                            Object object2;
                            PreparedStatement ps = (PreparedStatement)autoCloseable;
                            boolean bl = false;
                            JdbcExecutor.access$setUp(jdbcExecutor, ps);
                            JdbcExecutor.access$log(jdbcExecutor, statement);
                            JdbcExecutor.access$bind(jdbcExecutor, ps, statement);
                            AutoCloseable autoCloseable2 = ps.executeQuery();
                            Throwable throwable2 = null;
                            try {
                                ResultSet rs = (ResultSet)autoCloseable2;
                                boolean bl2 = false;
                                Iterator<T> iterator2 = new Iterator<T>(rs, function2, jdbcExecutor){
                                    private boolean hasNext;
                                    final /* synthetic */ ResultSet $rs;
                                    final /* synthetic */ Function2<JdbcDataOperator, ResultSet, T> $transform;
                                    final /* synthetic */ JdbcExecutor this$0;
                                    {
                                        this.$rs = $rs;
                                        this.$transform = $transform;
                                        this.this$0 = $receiver;
                                        this.hasNext = $rs.next();
                                    }

                                    public final boolean getHasNext() {
                                        return this.hasNext;
                                    }

                                    public final void setHasNext(boolean bl) {
                                        this.hasNext = bl;
                                    }

                                    public boolean hasNext() {
                                        return this.hasNext;
                                    }

                                    public T next() {
                                        JdbcDataOperator jdbcDataOperator = JdbcExecutor.access$getConfig$p(this.this$0).getDataOperator();
                                        ResultSet resultSet = this.$rs;
                                        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"rs");
                                        Object object = this.$transform.invoke((Object)jdbcDataOperator, (Object)resultSet);
                                        ResultSet resultSet2 = this.$rs;
                                        Object it = object;
                                        boolean bl = false;
                                        this.hasNext = resultSet2.next();
                                        return (T)object;
                                    }

                                    public void remove() {
                                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                                    }
                                };
                                object2 = BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super R>, Object>(function22, iterator2, null){
                                    int label;
                                    final /* synthetic */ Function2<Flow<? extends T>, Continuation<? super R>, Object> $collect;
                                    final /* synthetic */ executeQuery.1.1.iterator.1 $iterator;
                                    {
                                        this.$collect = $collect;
                                        this.$iterator = $iterator;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.$collect.invoke((Object)FlowKt.asFlow((Iterator)this.$iterator), (Object)((Object)this));
                                                if (object3 != object2) return object3;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return object3;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super R> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)1, null);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                            }
                            object = object2;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return (R)object;
                    }
                });
            }
        });
    }

    @NotNull
    public final Pair<Long, List<Long>> executeUpdate(@NotNull org.komapper.core.Statement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return (Pair)this.withExceptionTranslator((Function0)new Function0<Pair<? extends Long, ? extends List<? extends Long>>>(this, statement){
            final /* synthetic */ JdbcExecutor this$0;
            final /* synthetic */ org.komapper.core.Statement $statement;
            {
                this.this$0 = $receiver;
                this.$statement = $statement;
                super(0);
            }

            @NotNull
            public final Pair<Long, List<Long>> invoke() {
                org.komapper.core.Statement statement = JdbcExecutor.access$inspect(this.this$0, this.$statement);
                return (Pair)JdbcExecutor.access$getConfig$p(this.this$0).getSession().useConnection((Function1)new Function1<Connection, Pair<? extends Long, ? extends List<? extends Long>>>(this.this$0, statement){
                    final /* synthetic */ JdbcExecutor this$0;
                    final /* synthetic */ org.komapper.core.Statement $statement;
                    {
                        this.this$0 = $receiver;
                        this.$statement = $statement;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final Pair<Long, List<Long>> invoke(@NotNull Connection con) {
                        Pair pair;
                        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                        AutoCloseable autoCloseable = JdbcExecutor.access$prepare(this.this$0, con, this.$statement);
                        JdbcExecutor jdbcExecutor = this.this$0;
                        org.komapper.core.Statement statement = this.$statement;
                        Throwable throwable = null;
                        try {
                            PreparedStatement ps = (PreparedStatement)autoCloseable;
                            boolean bl = false;
                            JdbcExecutor.access$setUp(jdbcExecutor, ps);
                            JdbcExecutor.access$log(jdbcExecutor, statement);
                            JdbcExecutor.access$bind(jdbcExecutor, ps, statement);
                            int count = ps.executeUpdate();
                            List keys = JdbcExecutor.access$getGeneratedColumn$p(jdbcExecutor) == null ? CollectionsKt.emptyList() : JdbcExecutor.access$fetchGeneratedKeys(jdbcExecutor, ps);
                            pair = TuplesKt.to((Object)count, (Object)keys);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return pair;
                    }
                });
            }
        });
    }

    @NotNull
    public final List<Pair<Long, Long>> executeBatch(@NotNull List<org.komapper.core.Statement> statements) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        if (!(!((Collection)statements).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return (List)this.withExceptionTranslator((Function0)new Function0<List<Pair<? extends Long, ? extends Long>>>(statements, this){
            final /* synthetic */ List<org.komapper.core.Statement> $statements;
            final /* synthetic */ JdbcExecutor this$0;
            {
                this.$statements = $statements;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<Long, Long>> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$statements;
                JdbcExecutor jdbcExecutor = this.this$0;
                boolean $i$f$map = false;
                void var5_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    org.komapper.core.Statement statement = (org.komapper.core.Statement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(JdbcExecutor.access$inspect(jdbcExecutor, (org.komapper.core.Statement)it));
                }
                List statements = (List)destination$iv$iv;
                return (List)JdbcExecutor.access$getConfig$p(this.this$0).getSession().useConnection((Function1)new Function1<Connection, List<Pair<? extends Long, ? extends Long>>>(this.this$0, (List<org.komapper.core.Statement>)statements){
                    final /* synthetic */ JdbcExecutor this$0;
                    final /* synthetic */ List<org.komapper.core.Statement> $statements;
                    {
                        this.this$0 = $receiver;
                        this.$statements = $statements;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<Pair<Long, Long>> invoke(@NotNull Connection con) {
                        List list;
                        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                        AutoCloseable autoCloseable = JdbcExecutor.access$prepare(this.this$0, con, (org.komapper.core.Statement)CollectionsKt.first(this.$statements));
                        JdbcExecutor jdbcExecutor = this.this$0;
                        List<org.komapper.core.Statement> list2 = this.$statements;
                        Throwable throwable = null;
                        try {
                            PreparedStatement ps = (PreparedStatement)autoCloseable;
                            boolean bl = false;
                            JdbcExecutor.access$setUp(jdbcExecutor, ps);
                            List countAndKeyList = new ArrayList<E>();
                            int batchSize = JdbcExecutor.access$getExecutionOptions$p(jdbcExecutor).getValidBatchSize();
                            List batchStatementsList = CollectionsKt.chunked((Iterable)list2, (int)batchSize);
                            for (List batchStatements : batchStatementsList) {
                                List list3;
                                ArrayList<Pair> arrayList;
                                for (org.komapper.core.Statement statement : batchStatements) {
                                    JdbcExecutor.access$log(jdbcExecutor, statement);
                                    JdbcExecutor.access$bind(jdbcExecutor, ps, statement);
                                    ps.addBatch();
                                }
                                int[] counts = ps.executeBatch();
                                if (JdbcExecutor.access$getGeneratedColumn$p(jdbcExecutor) == null) {
                                    void $this$mapTo$iv$iv;
                                    Intrinsics.checkNotNullExpressionValue((Object)counts, (String)"counts");
                                    int[] $this$map$iv = counts;
                                    boolean $i$f$map = false;
                                    int[] nArray = $this$map$iv;
                                    ArrayList<Pair> destination$iv$iv = (ArrayList<Pair>)new ArrayList<E>($this$map$iv.length);
                                    boolean $i$f$mapTo = false;
                                    int n = ((void)$this$mapTo$iv$iv).length;
                                    for (int i = 0; i < n; ++i) {
                                        void it;
                                        void item$iv$iv;
                                        void var23_33 = item$iv$iv = $this$mapTo$iv$iv[i];
                                        arrayList = destination$iv$iv;
                                        boolean bl2 = false;
                                        arrayList.add(TuplesKt.to((Object)((long)it), null));
                                    }
                                    list3 = destination$iv$iv;
                                } else {
                                    List keys = JdbcExecutor.access$fetchGeneratedKeys(jdbcExecutor, ps);
                                    if (!(counts.length == keys.size())) {
                                        boolean $i$a$-check-JdbcExecutor$executeBatch$1$1$1$pairs$32 = false;
                                        String $i$a$-check-JdbcExecutor$executeBatch$1$1$1$pairs$32 = "counts.size=" + counts.length + ", keys.size=" + keys.size();
                                        throw new IllegalStateException($i$a$-check-JdbcExecutor$executeBatch$1$1$1$pairs$32.toString());
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)counts, (String)"counts");
                                    int[] $this$zip$iv = counts;
                                    boolean $i$f$zip = false;
                                    int arraySize$iv = $this$zip$iv.length;
                                    ArrayList<Pair> list$iv = new ArrayList<Pair>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)keys, (int)10), arraySize$iv));
                                    int i$iv = 0;
                                    for (T element$iv : (Iterable)keys) {
                                        void b;
                                        void a;
                                        if (i$iv >= arraySize$iv) break;
                                        int n = i$iv++;
                                        long l = ((Number)element$iv).longValue();
                                        int n2 = $this$zip$iv[n];
                                        arrayList = list$iv;
                                        boolean bl3 = false;
                                        arrayList.add(TuplesKt.to((Object)((long)a), (Object)((long)b)));
                                    }
                                    list3 = list$iv;
                                }
                                List pairs = list3;
                                countAndKeyList.addAll(pairs);
                            }
                            list = countAndKeyList;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return list;
                    }
                });
            }
        });
    }

    public final void execute(@NotNull List<org.komapper.core.Statement> statements, @NotNull Function1<? super SQLException, Unit> handler) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.withExceptionTranslator((Function0)new Function0<Unit>(statements, this, handler){
            final /* synthetic */ List<org.komapper.core.Statement> $statements;
            final /* synthetic */ JdbcExecutor this$0;
            final /* synthetic */ Function1<SQLException, Unit> $handler;
            {
                this.$statements = $statements;
                this.this$0 = $receiver;
                this.$handler = $handler;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$statements;
                JdbcExecutor jdbcExecutor = this.this$0;
                boolean $i$f$map = false;
                void var5_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    org.komapper.core.Statement statement = (org.komapper.core.Statement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(JdbcExecutor.access$inspect(jdbcExecutor, (org.komapper.core.Statement)it));
                }
                List statements = (List)destination$iv$iv;
                JdbcExecutor.access$getConfig$p(this.this$0).getSession().useConnection((Function1)new Function1<Connection, Unit>((List<org.komapper.core.Statement>)statements, this.this$0, this.$handler){
                    final /* synthetic */ List<org.komapper.core.Statement> $statements;
                    final /* synthetic */ JdbcExecutor this$0;
                    final /* synthetic */ Function1<SQLException, Unit> $handler;
                    {
                        this.$statements = $statements;
                        this.this$0 = $receiver;
                        this.$handler = $handler;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull Connection con) {
                        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                        for (org.komapper.core.Statement statement : this.$statements) {
                            AutoCloseable autoCloseable = con.createStatement();
                            JdbcExecutor jdbcExecutor = this.this$0;
                            Function1<SQLException, Unit> function1 = this.$handler;
                            Throwable throwable = null;
                            try {
                                Boolean bl;
                                Statement s = (Statement)autoCloseable;
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                                JdbcExecutor.access$setUp(jdbcExecutor, s);
                                JdbcExecutor.access$log(jdbcExecutor, statement);
                                String sql = JdbcExecutor.access$asSql(jdbcExecutor, statement);
                                try {
                                    bl = s.execute(sql);
                                }
                                catch (SQLException e) {
                                    function1.invoke((Object)e);
                                    bl = Unit.INSTANCE;
                                }
                                Boolean bl3 = bl;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                            }
                        }
                    }
                });
            }
        });
    }

    public static /* synthetic */ void execute$default(JdbcExecutor jdbcExecutor, List list, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = execute.1.INSTANCE;
        }
        jdbcExecutor.execute(list, (Function1<? super SQLException, Unit>)function1);
    }

    private final <T> T withExceptionTranslator(Function0<? extends T> block) {
        Object object;
        try {
            object = block.invoke();
        }
        catch (SQLException e) {
            if (this.config.getDialect().isUniqueConstraintViolationError(e)) {
                throw new UniqueConstraintException((Exception)e);
            }
            throw new JdbcException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        catch (Throwable cause) {
            throw cause;
        }
        return (T)object;
    }

    private final org.komapper.core.Statement inspect(org.komapper.core.Statement statement) {
        return this.config.getStatementInspector().inspect(statement);
    }

    private final void log(org.komapper.core.Statement statement) {
        boolean suppressLogging;
        Boolean bl = this.executionOptions.getSuppressLogging();
        boolean bl2 = suppressLogging = bl != null ? bl : false;
        if (!suppressLogging) {
            this.config.getLoggerFacade().sql(statement, (Function2)new Function2<Integer, StatementPart.Value, CharSequence>((Object)this.config.getDialect()){

                @NotNull
                public final CharSequence invoke(int p0, @NotNull StatementPart.Value p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((JdbcDialect)this.receiver).createBindVariable(p0, p1);
                }
            });
            this.config.getLoggerFacade().sqlWithArgs(statement, (Function3)new Function3<Object, KClass<? extends Object>, Boolean, String>((Object)this.config.getDataOperator()){

                @NotNull
                public final String invoke(@Nullable Object p0, @NotNull KClass<? extends Object> p1, boolean p2) {
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    return ((JdbcDataOperator)this.receiver).formatValue(p0, p1, p2);
                }
            });
        }
    }

    private final String asSql(org.komapper.core.Statement statement) {
        return statement.toSql((Function2)new Function2<Integer, StatementPart.Value, CharSequence>((Object)this.config.getDialect()){

            @NotNull
            public final CharSequence invoke(int p0, @NotNull StatementPart.Value p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((JdbcDialect)this.receiver).createBindVariable(p0, p1);
            }
        });
    }

    private final PreparedStatement prepare(Connection con, org.komapper.core.Statement statement) {
        PreparedStatement preparedStatement;
        String sql = this.asSql(statement);
        if (this.generatedColumn == null) {
            PreparedStatement preparedStatement2 = con.prepareStatement(sql);
            preparedStatement = preparedStatement2;
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement2, (String)"{\n            con.prepareStatement(sql)\n        }");
        } else {
            PreparedStatement preparedStatement3;
            if (this.config.getDialect().supportsReturnGeneratedKeysFlag()) {
                preparedStatement3 = con.prepareStatement(sql, 1);
            } else {
                String[] stringArray = new String[]{this.generatedColumn};
                preparedStatement3 = con.prepareStatement(sql, stringArray);
            }
            preparedStatement = preparedStatement3;
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement3, (String)"{\n            if (config\u2026)\n            }\n        }");
        }
        return preparedStatement;
    }

    private final void setUp(Statement statement) {
        block5: {
            int it;
            Integer n = this.executionOptions.getFetchSize();
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl = false;
                if (it > 0) {
                    statement.setFetchSize(it);
                }
            }
            Integer n2 = this.executionOptions.getMaxRows();
            if (n2 != null) {
                it = ((Number)n2).intValue();
                boolean bl = false;
                if (it > 0) {
                    statement.setMaxRows(it);
                }
            }
            Integer n3 = this.executionOptions.getQueryTimeoutSeconds();
            if (n3 == null) break block5;
            it = ((Number)n3).intValue();
            boolean bl = false;
            if (it > 0) {
                statement.setQueryTimeout(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void bind(PreparedStatement ps, org.komapper.core.Statement statement) {
        Iterable $this$forEachIndexed$iv = statement.getArgs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Value value2 = (Value)item$iv;
            int index = n;
            boolean bl = false;
            this.config.getDataOperator().setValue(ps, index + 1, value.getAny(), value.getKlass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Long> fetchGeneratedKeys(PreparedStatement ps) {
        List list;
        AutoCloseable autoCloseable = ps.getGeneratedKeys();
        Throwable throwable = null;
        try {
            ResultSet rs = (ResultSet)autoCloseable;
            boolean bl = false;
            List keys = new ArrayList();
            while (rs.next()) {
                long key = rs.getLong(1);
                keys.add(key);
            }
            list = keys;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    public static final /* synthetic */ org.komapper.core.Statement access$inspect(JdbcExecutor $this, org.komapper.core.Statement statement) {
        return $this.inspect(statement);
    }

    public static final /* synthetic */ JdbcDatabaseConfig access$getConfig$p(JdbcExecutor $this) {
        return $this.config;
    }

    public static final /* synthetic */ PreparedStatement access$prepare(JdbcExecutor $this, Connection con, org.komapper.core.Statement statement) {
        return $this.prepare(con, statement);
    }

    public static final /* synthetic */ void access$setUp(JdbcExecutor $this, Statement statement) {
        $this.setUp(statement);
    }

    public static final /* synthetic */ void access$log(JdbcExecutor $this, org.komapper.core.Statement statement) {
        $this.log(statement);
    }

    public static final /* synthetic */ void access$bind(JdbcExecutor $this, PreparedStatement ps, org.komapper.core.Statement statement) {
        $this.bind(ps, statement);
    }

    public static final /* synthetic */ String access$getGeneratedColumn$p(JdbcExecutor $this) {
        return $this.generatedColumn;
    }

    public static final /* synthetic */ List access$fetchGeneratedKeys(JdbcExecutor $this, PreparedStatement ps) {
        return $this.fetchGeneratedKeys(ps);
    }

    public static final /* synthetic */ ExecutionOptions access$getExecutionOptions$p(JdbcExecutor $this) {
        return $this.executionOptions;
    }

    public static final /* synthetic */ String access$asSql(JdbcExecutor $this, org.komapper.core.Statement statement) {
        return $this.asSql(statement);
    }
}

