/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.jdbc.AbstractJdbcDataType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004H\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/komapper/jdbc/JdbcInstantAsTimestampType;", "Lorg/komapper/jdbc/AbstractJdbcDataType;", "Ljava/time/Instant;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "doGetValue", "rs", "Ljava/sql/ResultSet;", "index", "", "columnLabel", "doSetValue", "", "ps", "Ljava/sql/PreparedStatement;", "value", "toInstant", "dateTime", "Ljava/time/LocalDateTime;", "komapper-jdbc"})
public final class JdbcInstantAsTimestampType
extends AbstractJdbcDataType<Instant> {
    @NotNull
    private final String name;

    public JdbcInstantAsTimestampType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(Reflection.getOrCreateKotlinClass(Instant.class), JDBCType.TIMESTAMP);
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    protected Instant doGetValue(@NotNull ResultSet rs, int index) {
        Instant instant;
        LocalDateTime dateTime;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        LocalDateTime localDateTime = dateTime = rs.getObject(index, LocalDateTime.class);
        if (localDateTime != null) {
            LocalDateTime it = localDateTime;
            boolean bl = false;
            instant = this.toInstant(it);
        } else {
            instant = null;
        }
        return instant;
    }

    @Override
    @Nullable
    protected Instant doGetValue(@NotNull ResultSet rs, @NotNull String columnLabel) {
        Instant instant;
        LocalDateTime dateTime;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)columnLabel, (String)"columnLabel");
        LocalDateTime localDateTime = dateTime = rs.getObject(columnLabel, LocalDateTime.class);
        if (localDateTime != null) {
            LocalDateTime it = localDateTime;
            boolean bl = false;
            instant = this.toInstant(it);
        } else {
            instant = null;
        }
        return instant;
    }

    @Override
    protected void doSetValue(@NotNull PreparedStatement ps, int index, @NotNull Instant value) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LocalDateTime datetime = LocalDateTime.ofInstant(value, ZoneOffset.UTC);
        ps.setObject(index, datetime);
    }

    private final Instant toInstant(LocalDateTime dateTime) {
        Instant instant = dateTime.toInstant(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"dateTime.toInstant(ZoneOffset.UTC)");
        return instant;
    }
}

