/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc;

import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.jdbc.JdbcDataType;
import org.komapper.jdbc.spi.JdbcUserDefinedDataType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\"R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/komapper/jdbc/JdbcUserDefinedDataTypeAdapter;", "T", "", "Lorg/komapper/jdbc/JdbcDataType;", "dataType", "Lorg/komapper/jdbc/spi/JdbcUserDefinedDataType;", "(Lorg/komapper/jdbc/spi/JdbcUserDefinedDataType;)V", "jdbcType", "Ljava/sql/JDBCType;", "getJdbcType", "()Ljava/sql/JDBCType;", "klass", "Lkotlin/reflect/KClass;", "getKlass", "()Lkotlin/reflect/KClass;", "name", "", "getName", "()Ljava/lang/String;", "getValue", "rs", "Ljava/sql/ResultSet;", "index", "", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "columnLabel", "(Ljava/sql/ResultSet;Ljava/lang/String;)Ljava/lang/Object;", "setValue", "", "ps", "Ljava/sql/PreparedStatement;", "value", "(Ljava/sql/PreparedStatement;ILjava/lang/Object;)V", "toString", "(Ljava/lang/Object;)Ljava/lang/String;", "komapper-jdbc"})
public final class JdbcUserDefinedDataTypeAdapter<T>
implements JdbcDataType<T> {
    @NotNull
    private final JdbcUserDefinedDataType<T> dataType;

    public JdbcUserDefinedDataTypeAdapter(@NotNull JdbcUserDefinedDataType<T> dataType) {
        Intrinsics.checkNotNullParameter(dataType, (String)"dataType");
        this.dataType = dataType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.dataType.getName();
    }

    @Override
    @NotNull
    public KClass<T> getKlass() {
        return this.dataType.getKlass();
    }

    @Override
    @NotNull
    public JDBCType getJdbcType() {
        return this.dataType.getJdbcType();
    }

    @Override
    @Nullable
    public T getValue(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        T value = this.dataType.getValue(rs, index);
        return rs.wasNull() ? null : (T)value;
    }

    @Override
    @Nullable
    public T getValue(@NotNull ResultSet rs, @NotNull String columnLabel) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Intrinsics.checkNotNullParameter((Object)columnLabel, (String)"columnLabel");
        T value = this.dataType.getValue(rs, columnLabel);
        return rs.wasNull() ? null : (T)value;
    }

    @Override
    public void setValue(@NotNull PreparedStatement ps, int index, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        if (value == null) {
            Integer n = this.dataType.getJdbcType().getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"dataType.jdbcType.vendorTypeNumber");
            ps.setNull(index, ((Number)n).intValue());
        } else {
            this.dataType.setValue(ps, index, value);
        }
    }

    @Override
    @NotNull
    public String toString(@Nullable T value) {
        return value == null ? "null" : this.dataType.toString(value);
    }
}

