/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.jdbc.dsl.runner;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.DatabaseConfig;
import org.komapper.core.DryRunStatement;
import org.komapper.core.ExecutionOptionsProvider;
import org.komapper.core.Statement;
import org.komapper.core.dsl.context.TemplateExecuteContext;
import org.komapper.core.dsl.runner.TemplateExecuteRunner;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcExecutor;
import org.komapper.jdbc.dsl.runner.JdbcRunner;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/komapper/jdbc/dsl/runner/JdbcTemplateExecuteRunner;", "Lorg/komapper/jdbc/dsl/runner/JdbcRunner;", "", "context", "Lorg/komapper/core/dsl/context/TemplateExecuteContext;", "(Lorg/komapper/core/dsl/context/TemplateExecuteContext;)V", "runner", "Lorg/komapper/core/dsl/runner/TemplateExecuteRunner;", "check", "", "config", "Lorg/komapper/core/DatabaseConfig;", "dryRun", "Lorg/komapper/core/DryRunStatement;", "run", "Lorg/komapper/jdbc/JdbcDatabaseConfig;", "(Lorg/komapper/jdbc/JdbcDatabaseConfig;)Ljava/lang/Long;", "komapper-jdbc"})
public final class JdbcTemplateExecuteRunner
implements JdbcRunner<Long> {
    @NotNull
    private final TemplateExecuteContext context;
    @NotNull
    private final TemplateExecuteRunner runner;

    public JdbcTemplateExecuteRunner(@NotNull TemplateExecuteContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.runner = new TemplateExecuteRunner(this.context);
    }

    public void check(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.runner.check(config);
    }

    @Override
    @NotNull
    public Long run(@NotNull JdbcDatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Statement statement = this.runner.buildStatement((DatabaseConfig)config);
        JdbcExecutor executor = new JdbcExecutor(config, (ExecutionOptionsProvider)this.context.getOptions(), null, 4, null);
        long count = ((Number)executor.executeUpdate(statement).component1()).longValue();
        return count;
    }

    @NotNull
    public DryRunStatement dryRun(@NotNull DatabaseConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.runner.dryRun(config);
    }
}

