/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.processor.Config;
import org.komapper.processor.Entity;
import org.komapper.processor.EntityAnalysisResult;
import org.komapper.processor.EntityDef;
import org.komapper.processor.EntityDefFactory;
import org.komapper.processor.EntityDefinitionSource;
import org.komapper.processor.EntityDefinitionSourceResolver;
import org.komapper.processor.EntityFactory;
import org.komapper.processor.EntityModel;
import org.komapper.processor.Exit;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/komapper/processor/EntityAnalyzer;", "", "config", "Lorg/komapper/processor/Config;", "definitionSourceResolver", "Lorg/komapper/processor/EntityDefinitionSourceResolver;", "(Lorg/komapper/processor/Config;Lorg/komapper/processor/EntityDefinitionSourceResolver;)V", "analyze", "Lorg/komapper/processor/EntityAnalysisResult;", "symbol", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "komapper-processor"})
public final class EntityAnalyzer {
    @NotNull
    private final Config config;
    @NotNull
    private final EntityDefinitionSourceResolver definitionSourceResolver;

    public EntityAnalyzer(@NotNull Config config, @NotNull EntityDefinitionSourceResolver definitionSourceResolver) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)definitionSourceResolver, (String)"definitionSourceResolver");
        this.config = config;
        this.definitionSourceResolver = definitionSourceResolver;
    }

    @NotNull
    public final EntityAnalysisResult analyze(@NotNull KSAnnotated symbol) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        try {
            object = this.definitionSourceResolver.resolve((KSNode)symbol);
        }
        catch (Exit e) {
            return new EntityAnalysisResult.Error(e);
        }
        EntityDefinitionSource definitionSource = object;
        try {
            EntityDef entityDef = new EntityDefFactory(this.config, definitionSource).create();
            Entity entity = new EntityFactory(this.config, entityDef).create();
            EntityModel model = new EntityModel(definitionSource, entity);
            object = new EntityAnalysisResult.Success(model);
        }
        catch (Exit e) {
            EntityModel model = new EntityModel(definitionSource, null, 2, null);
            object = new EntityAnalysisResult.Failure(model, e);
        }
        return object;
    }
}

