/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.Modifier;
import java.util.Collection;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import org.komapper.processor.ExitKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"validateEnclosingDeclaration", "", "enclosed", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "enclosing", "recipient", "Lcom/google/devtools/ksp/symbol/KSNode;", "validateEntityDeclaration", "entityDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "komapper-processor"})
public final class EntityDefinitionSourceResolverKt {
    private static final void validateEntityDeclaration(KSClassDeclaration entityDeclaration2, KSNode recipient) {
        Set modifiers = entityDeclaration2.getModifiers();
        if (!modifiers.contains(Modifier.DATA)) {
            ExitKt.report("The entity class \"" + entityDeclaration2.getSimpleName().asString() + "\" must be a data class.", recipient);
            throw new KotlinNothingValueException();
        }
        if (!((Collection)entityDeclaration2.getTypeParameters()).isEmpty()) {
            ExitKt.report("The entity class \"" + entityDeclaration2.getSimpleName().asString() + "\" must not have type parameters.", recipient);
            throw new KotlinNothingValueException();
        }
        if (UtilsKt.isPrivate((KSDeclaration)((KSDeclaration)entityDeclaration2))) {
            ExitKt.report("The entity class \"" + entityDeclaration2.getSimpleName().asString() + "\" must not be private.", recipient);
            throw new KotlinNothingValueException();
        }
        EntityDefinitionSourceResolverKt.validateEnclosingDeclaration((KSDeclaration)entityDeclaration2, entityDeclaration2.getParentDeclaration(), recipient);
    }

    private static final void validateEnclosingDeclaration(KSDeclaration enclosed, KSDeclaration enclosing, KSNode recipient) {
        if (enclosing == null) {
            return;
        }
        if (!UtilsKt.isPublic((KSDeclaration)enclosing)) {
            String enclosingName = enclosing.getSimpleName().asString();
            String enclosedName = enclosed.getSimpleName().asString();
            ExitKt.report("The enclosing declaration \"" + enclosingName + "\" of the entity class \"" + enclosedName + "\" must be public.", recipient);
            throw new KotlinNothingValueException();
        }
        EntityDefinitionSourceResolverKt.validateEnclosingDeclaration(enclosed, enclosing.getParentDeclaration(), recipient);
    }

    public static final /* synthetic */ void access$validateEntityDeclaration(KSClassDeclaration entityDeclaration2, KSNode recipient) {
        EntityDefinitionSourceResolverKt.validateEntityDeclaration(entityDeclaration2, recipient);
    }
}

