/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.komapper.annotation.KomapperEntity;
import org.komapper.annotation.KomapperEntityDef;
import org.komapper.processor.Config;
import org.komapper.processor.EntityAnalysisResult;
import org.komapper.processor.EntityAnalyzer;
import org.komapper.processor.EntityDefinitionSourceResolver;
import org.komapper.processor.EntityMetamodelGenerator;
import org.komapper.processor.EntityMetamodelStubGenerator;
import org.komapper.processor.EntityModel;
import org.komapper.processor.Exit;
import org.komapper.processor.ProcessorUtilityKt;
import org.komapper.processor.SelfDefinitionSourceResolver;
import org.komapper.processor.SeparateDefinitionSourceResolver;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/komapper/processor/EntityProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "config", "Lorg/komapper/processor/Config;", "generateMetamodel", "", "model", "Lorg/komapper/processor/EntityModel;", "log", "exit", "Lorg/komapper/processor/Exit;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "komapper-processor"})
public final class EntityProcessor
implements SymbolProcessor {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    @NotNull
    private final Config config;

    public EntityProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.config = Config.Companion.create(this.environment.getOptions());
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Pair[] pairArray = new Pair[2];
        String string = Reflection.getOrCreateKotlinClass(KomapperEntityDef.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        pairArray[0] = TuplesKt.to((Object)string, (Object)new SeparateDefinitionSourceResolver());
        String string2 = Reflection.getOrCreateKotlinClass(KomapperEntity.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string2);
        pairArray[1] = TuplesKt.to((Object)string2, (Object)new SelfDefinitionSourceResolver());
        List pairs = CollectionsKt.listOf((Object[])pairArray);
        for (Pair pair : pairs) {
            String annotation = (String)pair.component1();
            EntityDefinitionSourceResolver definitionSourceResolver = (EntityDefinitionSourceResolver)pair.component2();
            Sequence symbols = Resolver.DefaultImpls.getSymbolsWithAnnotation$default((Resolver)resolver, (String)annotation, (boolean)false, (int)2, null);
            EntityAnalyzer analyzer = new EntityAnalyzer(this.config, definitionSourceResolver);
            for (KSAnnotated symbol : symbols) {
                EntityModel entityModel;
                EntityAnalysisResult result = analyzer.analyze(symbol);
                if (result instanceof EntityAnalysisResult.Success) {
                    entityModel = ((EntityAnalysisResult.Success)result).getModel();
                } else if (result instanceof EntityAnalysisResult.Failure) {
                    this.log(((EntityAnalysisResult.Failure)result).getExit());
                    entityModel = ((EntityAnalysisResult.Failure)result).getModel();
                } else {
                    if (result instanceof EntityAnalysisResult.Error) {
                        this.log(((EntityAnalysisResult.Error)result).getExit());
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                EntityModel model = entityModel;
                this.generateMetamodel(model);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final void log(Exit exit) {
        this.environment.getLogger().error(exit.getReport().getMessage(), exit.getReport().getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateMetamodel(EntityModel model) {
        Object object;
        KSClassDeclaration declaration = model.getDefinitionSource().getEntityDeclaration();
        Pair<String, String> pair = (Pair<String, String>)model.getDefinitionSource().getAliases();
        if (pair.isEmpty()) {
            boolean bl = false;
            String alias = ProcessorUtilityKt.toCamelCase(declaration.getSimpleName().asString());
            object = CollectionsKt.listOf((Object)alias);
        } else {
            object = pair;
        }
        List aliases = (List)object;
        pair = EntityProcessor.generateMetamodel$createClassName(model, this);
        String packageName = (String)pair.component1();
        String simpleName = (String)pair.component2();
        Object object2 = new KSFile[1];
        Intrinsics.checkNotNull((Object)declaration.getContainingFile());
        Dependencies dependencies = new Dependencies(false, object2);
        object2 = CodeGenerator.DefaultImpls.createNewFile$default((CodeGenerator)this.environment.getCodeGenerator(), (Dependencies)dependencies, (String)packageName, (String)simpleName, null, (int)8, null);
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)object2;
            boolean bl = false;
            Closeable closeable = new PrintWriter(out);
            Throwable throwable2 = null;
            try {
                PrintWriter it = (PrintWriter)closeable;
                boolean bl2 = false;
                Object object3 = model.getDefinitionSource().getEntityDeclaration().getQualifiedName();
                if (object3 == null || (object3 = object3.asString()) == null) {
                    object3 = "";
                }
                Object entityTypeName = object3;
                Runnable runnable = model.getDefinitionSource().getStubAnnotation() != null || model.getEntity() == null ? (Runnable)new EntityMetamodelStubGenerator(declaration, this.config.getMetaObject(), aliases, packageName, simpleName, (String)entityTypeName, it) : (Runnable)new EntityMetamodelGenerator(model.getEntity(), this.config.getMetaObject(), aliases, packageName, simpleName, (String)entityTypeName, it);
                runnable.run();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }

    public void finish() {
        SymbolProcessor.DefaultImpls.finish((SymbolProcessor)this);
    }

    public void onError() {
        SymbolProcessor.DefaultImpls.onError((SymbolProcessor)this);
    }

    private static final Pair<String, String> generateMetamodel$createClassName(EntityModel $model, EntityProcessor this$0) {
        KSClassDeclaration defDeclaration2 = $model.getDefinitionSource().getDefDeclaration();
        String packageName = defDeclaration2.getPackageName().asString();
        Object object = defDeclaration2.getQualifiedName();
        if (object == null || (object = object.asString()) == null) {
            object = "";
        }
        Object qualifiedName = object;
        String packageRemovedQualifiedName = StringsKt.removePrefix((String)qualifiedName, (CharSequence)(packageName + "."));
        String simpleName = this$0.config.getPrefix() + StringsKt.replace$default((String)packageRemovedQualifiedName, (String)".", (String)"_", (boolean)false, (int)4, null) + this$0.config.getSuffix();
        return TuplesKt.to((Object)packageName, (Object)simpleName);
    }
}

