/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeAlias;
import com.google.devtools.ksp.symbol.KSValueArgument;
import com.google.devtools.ksp.symbol.KSVisitor;
import com.google.devtools.ksp.symbol.Modifier;
import com.google.devtools.ksp.visitor.KSEmptyVisitor;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0000\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a,\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\r0\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\r*\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0000\u00a8\u0006\u0016"}, d2={"toCamelCase", "", "text", "findAnnotation", "Lcom/google/devtools/ksp/symbol/KSAnnotation;", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "simpleName", "klass", "Lkotlin/reflect/KClass;", "findValue", "", "name", "hasDuplicates", "", "T", "Lkotlin/sequences/Sequence;", "predicate", "Lkotlin/Function1;", "isValueClass", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "normalize", "Lcom/google/devtools/ksp/symbol/KSType;", "komapper-processor"})
public final class ProcessorUtilityKt {
    public static final <T> boolean hasDuplicates(@NotNull Sequence<? extends T> $this$hasDuplicates, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$hasDuplicates, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return SequencesKt.count((Sequence)SequencesKt.take((Sequence)SequencesKt.filter($this$hasDuplicates, predicate), (int)2)) == 2;
    }

    public static final boolean isValueClass(@NotNull KSClassDeclaration $this$isValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClass, (String)"<this>");
        return $this$isValueClass.getModifiers().contains(Modifier.VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object findValue(@NotNull KSAnnotation $this$findValue, @NotNull String name) {
        void $this$mapTo$iv$iv;
        KSValueArgument it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = $this$findValue.getArguments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KSValueArgument)element$iv$iv;
            boolean bl = false;
            KSName kSName = it.getName();
            if (!Intrinsics.areEqual((Object)(kSName != null ? kSName.asString() : null), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KSValueArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        return CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @Nullable
    public static final KSAnnotation findAnnotation(@NotNull KSAnnotated $this$findAnnotation, @NotNull KClass<?> klass) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Sequence $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KSAnnotation it = (KSAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName().asString(), (Object)klass.getSimpleName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final KSAnnotation findAnnotation(@NotNull KSAnnotated $this$findAnnotation, @NotNull String simpleName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Sequence $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KSAnnotation it = (KSAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName().asString(), (Object)simpleName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final KSType normalize(@NotNull KSType $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        return (KSType)$this$normalize.getDeclaration().accept((KSVisitor)new KSEmptyVisitor<Unit, KSType>($this$normalize){
            final /* synthetic */ KSType $this_normalize;
            {
                this.$this_normalize = $receiver;
            }

            @NotNull
            public KSType defaultHandler(@NotNull KSNode node, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return this.$this_normalize;
            }

            @NotNull
            public KSType visitTypeAlias(@NotNull KSTypeAlias typeAlias, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return ProcessorUtilityKt.normalize(typeAlias.getType().resolve());
            }
        }, (Object)Unit.INSTANCE);
    }

    @NotNull
    public static final String toCamelCase(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        StringBuilder builder = new StringBuilder();
        CharBuffer buf = CharBuffer.wrap(text);
        if (buf.hasRemaining()) {
            builder.append(Character.toLowerCase(buf.get()));
        }
        while (buf.hasRemaining()) {
            char c1 = buf.get();
            buf.mark();
            if (buf.hasRemaining()) {
                char c2 = buf.get();
                if (Character.isUpperCase(c1) && Character.isLowerCase(c2)) {
                    builder.append(c1).append(c2).append(buf);
                    break;
                }
                builder.append(Character.toLowerCase(c1));
                buf.reset();
                continue;
            }
            builder.append(Character.toLowerCase(c1));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }
}

