/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFile;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.komapper.processor.Context;
import org.komapper.processor.ContextFactory;
import org.komapper.processor.EntityAnalysisResult;
import org.komapper.processor.EntityAnalyzer;
import org.komapper.processor.EntityDefinitionSourceResolver;
import org.komapper.processor.EntityMetamodelGenerator;
import org.komapper.processor.EntityMetamodelStubGenerator;
import org.komapper.processor.EntityModel;
import org.komapper.processor.Exit;
import org.komapper.processor.ProcessingAnnotation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/komapper/processor/EntityProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "contextFactory", "Lorg/komapper/processor/ContextFactory;", "processingAnnotations", "", "Lorg/komapper/processor/ProcessingAnnotation;", "<init>", "(Lorg/komapper/processor/ContextFactory;Ljava/util/List;)V", "processedSymbols", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "process", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "log", "", "context", "Lorg/komapper/processor/Context;", "exit", "Lorg/komapper/processor/Exit;", "generateMetamodel", "model", "Lorg/komapper/processor/EntityModel;", "komapper-processor"})
@SourceDebugExtension(value={"SMAP\nEntityProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityProcessor.kt\norg/komapper/processor/EntityProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n37#2,2:88\n*S KotlinDebug\n*F\n+ 1 EntityProcessor.kt\norg/komapper/processor/EntityProcessor\n*L\n55#1:88,2\n*E\n"})
public final class EntityProcessor
implements SymbolProcessor {
    @NotNull
    private final ContextFactory contextFactory;
    @NotNull
    private final List<ProcessingAnnotation> processingAnnotations;
    @NotNull
    private final Set<KSAnnotated> processedSymbols;

    public EntityProcessor(@NotNull ContextFactory contextFactory, @NotNull List<ProcessingAnnotation> processingAnnotations2) {
        Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
        Intrinsics.checkNotNullParameter(processingAnnotations2, (String)"processingAnnotations");
        this.contextFactory = contextFactory;
        this.processingAnnotations = processingAnnotations2;
        this.processedSymbols = new LinkedHashSet();
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Context context = this.contextFactory.create(resolver);
        for (ProcessingAnnotation annotation : this.processingAnnotations) {
            String annotationName;
            Intrinsics.checkNotNull((Object)annotation.getAnnotationClass().getQualifiedName());
            Sequence symbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)annotationName, (boolean)false, (int)2, null);
            EntityAnalyzer analyzer = new EntityAnalyzer(context, (EntityDefinitionSourceResolver)annotation.getCreateEntityDefinitionSourceResolver().invoke((Object)context), annotation.getRequiresIdValidation());
            for (KSAnnotated symbol : SequencesKt.minus((Sequence)symbols, (Iterable)this.processedSymbols)) {
                EntityModel entityModel;
                EntityAnalysisResult result = analyzer.analyze(symbol);
                if (result instanceof EntityAnalysisResult.Success) {
                    entityModel = ((EntityAnalysisResult.Success)result).getModel();
                } else if (result instanceof EntityAnalysisResult.Failure) {
                    this.log(context, ((EntityAnalysisResult.Failure)result).getExit());
                    entityModel = ((EntityAnalysisResult.Failure)result).getModel();
                } else {
                    if (result instanceof EntityAnalysisResult.Error) {
                        this.log(context, ((EntityAnalysisResult.Error)result).getExit());
                        continue;
                    }
                    if (result instanceof EntityAnalysisResult.Skip) continue;
                    throw new NoWhenBranchMatchedException();
                }
                EntityModel model = entityModel;
                this.generateMetamodel(context, model);
            }
            CollectionsKt.addAll((Collection)this.processedSymbols, (Sequence)symbols);
        }
        return CollectionsKt.emptyList();
    }

    private final void log(Context context, Exit exit) {
        context.getLogger().error(exit.getReport().getMessage(), exit.getReport().getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateMetamodel(Context context, EntityModel model) {
        Collection $this$toTypedArray$iv = model.getContainingFiles();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair<String, String> pair = thisCollection$iv.toArray(new KSFile[0]);
        Dependencies dependencies = new Dependencies(false, Arrays.copyOf(pair, ((KSFile[])pair).length));
        pair = model.createMetamodelClassName();
        String packageName = (String)pair.component1();
        String simpleName = (String)pair.component2();
        Closeable closeable = CodeGenerator.createNewFile$default((CodeGenerator)context.getCodeGenerator(), (Dependencies)dependencies, (String)packageName, (String)simpleName, null, (int)8, null);
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new PrintWriter(out);
            Throwable throwable2 = null;
            try {
                PrintWriter writer = (PrintWriter)closeable2;
                boolean bl2 = false;
                Runnable runnable = model.getHasStubAnnotation() || model.getEntity() == null ? (Runnable)new EntityMetamodelStubGenerator(context, model.getEntityDeclaration(), model.getUnitTypeName(), model.getAliases(), packageName, simpleName, model.getTypeName(), writer) : (Runnable)new EntityMetamodelGenerator(context, model.getEntity(), model.getUnitTypeName(), model.getAliases(), packageName, simpleName, model.getTypeName(), writer);
                runnable.run();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

