/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.processor.KotlinClass;
import org.komapper.processor.ProcessorUtilityKt;
import org.komapper.processor.ValueClass;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/komapper/processor/PlainClass;", "Lorg/komapper/processor/KotlinClass;", "type", "Lcom/google/devtools/ksp/symbol/KSType;", "alternateType", "Lorg/komapper/processor/ValueClass;", "<init>", "(Lcom/google/devtools/ksp/symbol/KSType;Lorg/komapper/processor/ValueClass;)V", "getType", "()Lcom/google/devtools/ksp/symbol/KSType;", "getAlternateType", "()Lorg/komapper/processor/ValueClass;", "isArray", "", "()Z", "typeName", "", "getTypeName", "()Ljava/lang/String;", "exteriorTypeName", "getExteriorTypeName", "interiorTypeName", "getInteriorTypeName", "toString", "makeNonNullableType", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "komapper-processor"})
public final class PlainClass
implements KotlinClass {
    @NotNull
    private final KSType type;
    @Nullable
    private final ValueClass alternateType;
    private final boolean isArray;

    public PlainClass(@NotNull KSType type, @Nullable ValueClass alternateType) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        this.alternateType = alternateType;
        KSName kSName = this.getDeclaration().getQualifiedName();
        this.isArray = Intrinsics.areEqual((Object)(kSName != null ? kSName.asString() : null), (Object)"kotlin.Array");
    }

    @Override
    @NotNull
    public KSType getType() {
        return this.type;
    }

    @Nullable
    public final ValueClass getAlternateType() {
        return this.alternateType;
    }

    public final boolean isArray() {
        return this.isArray;
    }

    @Override
    @NotNull
    public String getTypeName() {
        String string;
        if (this.isArray) {
            KSType nonNullableType = this.makeNonNullableType(this.getType());
            string = ProcessorUtilityKt.getName(nonNullableType);
        } else {
            string = KotlinClass.DefaultImpls.getTypeName(this);
        }
        return string;
    }

    @Override
    @NotNull
    public String getExteriorTypeName() {
        String string;
        if (this.isArray) {
            KSType nonNullableType = this.makeNonNullableType(this.getType());
            string = ProcessorUtilityKt.getBackquotedName(nonNullableType);
        } else {
            string = KotlinClass.DefaultImpls.getExteriorTypeName(this);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInteriorTypeName() {
        Object object = this.alternateType;
        if (object == null || (object = ((ValueClass)object).getExteriorTypeName()) == null) {
            object = this.getExteriorTypeName();
        }
        return object;
    }

    @NotNull
    public String toString() {
        return this.getExteriorTypeName();
    }

    private final KSType makeNonNullableType(KSType type) {
        return type.isMarkedNullable() ? type.makeNotNullable() : type;
    }

    @NotNull
    public final KSType component1() {
        return this.type;
    }

    @Nullable
    public final ValueClass component2() {
        return this.alternateType;
    }

    @NotNull
    public final PlainClass copy(@NotNull KSType type, @Nullable ValueClass alternateType) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new PlainClass(type, alternateType);
    }

    public static /* synthetic */ PlainClass copy$default(PlainClass plainClass, KSType kSType, ValueClass valueClass, int n, Object object) {
        if ((n & 1) != 0) {
            kSType = plainClass.type;
        }
        if ((n & 2) != 0) {
            valueClass = plainClass.alternateType;
        }
        return plainClass.copy(kSType, valueClass);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + (this.alternateType == null ? 0 : this.alternateType.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlainClass)) {
            return false;
        }
        PlainClass plainClass = (PlainClass)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)plainClass.type)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.alternateType, (Object)plainClass.alternateType);
    }

    @Override
    @NotNull
    public KSDeclaration getDeclaration() {
        return KotlinClass.DefaultImpls.getDeclaration(this);
    }
}

