/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.Modifier;
import java.util.Collection;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.processor.ExitKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\"\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"validateContainerClass", "", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "recipient", "Lcom/google/devtools/ksp/symbol/KSNode;", "allowTypeParameters", "", "validateEnclosingDeclaration", "enclosed", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "enclosing", "komapper-processor"})
public final class ValidatorKt {
    public static final void validateContainerClass(@NotNull KSClassDeclaration classDeclaration, @NotNull KSNode recipient, boolean allowTypeParameters) {
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        Set modifiers = classDeclaration.getModifiers();
        if (!modifiers.contains(Modifier.DATA)) {
            ExitKt.report("The class \"" + classDeclaration.getSimpleName().asString() + "\" must be a data class.", recipient);
            throw new KotlinNothingValueException();
        }
        if (!allowTypeParameters && !((Collection)classDeclaration.getTypeParameters()).isEmpty()) {
            ExitKt.report("The class \"" + classDeclaration.getSimpleName().asString() + "\" must not have type parameters.", recipient);
            throw new KotlinNothingValueException();
        }
        if (UtilsKt.isPrivate((KSDeclaration)((KSDeclaration)classDeclaration))) {
            ExitKt.report("The class \"" + classDeclaration.getSimpleName().asString() + "\" must not be private.", recipient);
            throw new KotlinNothingValueException();
        }
        ValidatorKt.validateEnclosingDeclaration((KSDeclaration)classDeclaration, classDeclaration.getParentDeclaration(), recipient);
    }

    public static /* synthetic */ void validateContainerClass$default(KSClassDeclaration kSClassDeclaration, KSNode kSNode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ValidatorKt.validateContainerClass(kSClassDeclaration, kSNode, bl);
    }

    private static final void validateEnclosingDeclaration(KSDeclaration enclosed, KSDeclaration enclosing, KSNode recipient) {
        if (enclosing == null) {
            return;
        }
        if (!UtilsKt.isPublic((KSDeclaration)enclosing)) {
            String enclosingName = enclosing.getSimpleName().asString();
            String enclosedName = enclosed.getSimpleName().asString();
            ExitKt.report("The enclosing declaration \"" + enclosingName + "\" of the class \"" + enclosedName + "\" must be public.", recipient);
            throw new KotlinNothingValueException();
        }
        ValidatorKt.validateEnclosingDeclaration(enclosed, enclosing.getParentDeclaration(), recipient);
    }
}

