/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.quarkus.jdbc;

import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Default;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.komapper.core.BuilderDialectKt;
import org.komapper.core.ClockProvider;
import org.komapper.core.DataOperator;
import org.komapper.core.Dialect;
import org.komapper.core.ExecutionOptions;
import org.komapper.core.Logger;
import org.komapper.core.LoggerFacade;
import org.komapper.core.StatementInspector;
import org.komapper.core.TemplateStatementBuilder;
import org.komapper.core.TemplateStatementBuilders;
import org.komapper.jdbc.DefaultJdbcDataFactory;
import org.komapper.jdbc.DefaultJdbcDataOperator;
import org.komapper.jdbc.JdbcDataFactory;
import org.komapper.jdbc.JdbcDataOperator;
import org.komapper.jdbc.JdbcDataTypeProvider;
import org.komapper.jdbc.JdbcDataTypeProviders;
import org.komapper.jdbc.JdbcDatabase;
import org.komapper.jdbc.JdbcDatabaseConfig;
import org.komapper.jdbc.JdbcDatabaseKt;
import org.komapper.jdbc.JdbcDialect;
import org.komapper.jdbc.JdbcDialects;
import org.komapper.jdbc.JdbcSession;
import org.komapper.quarkus.jdbc.DataSourceDefinition;
import org.komapper.quarkus.jdbc.DataSourceResolver;
import org.komapper.quarkus.jdbc.QuarkusJdbcTransactionSession;

@Recorder
public class KomapperRecorder {
    public Supplier<JdbcDatabaseConfig> configureJdbcDatabaseConfig(DataSourceDefinition dataSourceDefinition) {
        Objects.requireNonNull(dataSourceDefinition);
        return () -> {
            ArcContainer container = Arc.container();
            TransactionManager transactionManager = (TransactionManager)container.instance(TransactionManager.class, new Annotation[0]).get();
            DataSourceResolver dataSourceResolver = (DataSourceResolver)container.instance(DataSourceResolver.class, new Annotation[0]).get();
            ExecutionOptions executionOptions = (ExecutionOptions)container.instance(ExecutionOptions.class, new Annotation[0]).get();
            final ClockProvider clockProvider = (ClockProvider)container.instance(ClockProvider.class, new Annotation[0]).get();
            final Logger logger = (Logger)container.instance(Logger.class, new Annotation[0]).get();
            final LoggerFacade loggerFacade = (LoggerFacade)container.instance(LoggerFacade.class, new Annotation[0]).get();
            final StatementInspector statementInspector = (StatementInspector)container.instance(StatementInspector.class, new Annotation[0]).get();
            final UUID id = UUID.randomUUID();
            final JdbcDialect dialect = JdbcDialects.INSTANCE.get(dataSourceDefinition.driver);
            JdbcDataTypeProvider dataTypeProvider = JdbcDataTypeProviders.INSTANCE.get(dialect.getDriver(), null);
            final DefaultJdbcDataOperator dataOperator = new DefaultJdbcDataOperator(dialect, dataTypeProvider);
            final TemplateStatementBuilder templateStatementBuilder = TemplateStatementBuilders.INSTANCE.get(BuilderDialectKt.BuilderDialect((Dialect)dialect, (DataOperator)dataOperator));
            final DataSource dataSource = dataSourceResolver.resolve(dataSourceDefinition.name);
            final QuarkusJdbcTransactionSession session = new QuarkusJdbcTransactionSession(transactionManager, dataSource);
            final DefaultJdbcDataFactory dataFactory = new DefaultJdbcDataFactory((JdbcSession)session);
            final ExecutionOptions newExecutionOptions = executionOptions.plus(new ExecutionOptions(Integer.valueOf(dataSourceDefinition.batchSize), Integer.valueOf(dataSourceDefinition.maxRows), Integer.valueOf(dataSourceDefinition.fetchSize), Integer.valueOf(dataSourceDefinition.queryTimeout), Boolean.valueOf(false)));
            return new JdbcDatabaseConfig(){

                public JdbcDataFactory getDataFactory() {
                    return dataFactory;
                }

                public JdbcDataOperator getDataOperator() {
                    return dataOperator;
                }

                public DataSource getDataSource() {
                    return dataSource;
                }

                public JdbcSession getSession() {
                    return session;
                }

                public JdbcDialect getDialect() {
                    return dialect;
                }

                public TemplateStatementBuilder getTemplateStatementBuilder() {
                    return templateStatementBuilder;
                }

                public StatementInspector getStatementInspector() {
                    return statementInspector;
                }

                public LoggerFacade getLoggerFacade() {
                    return loggerFacade;
                }

                public Logger getLogger() {
                    return logger;
                }

                public ExecutionOptions getExecutionOptions() {
                    return newExecutionOptions;
                }

                public ClockProvider getClockProvider() {
                    return clockProvider;
                }

                public UUID getId() {
                    return id;
                }
            };
        };
    }

    public Supplier<JdbcDatabase> configureJdbcDatabase(DataSourceDefinition dataSourceDefinition) {
        Objects.requireNonNull(dataSourceDefinition);
        return () -> {
            JdbcDatabaseConfig config = this.resolveJdbcDatabaseConfig(dataSourceDefinition);
            return JdbcDatabaseKt.JdbcDatabase((JdbcDatabaseConfig)config);
        };
    }

    private JdbcDatabaseConfig resolveJdbcDatabaseConfig(DataSourceDefinition dataSourceDefinition) {
        Annotation qualifier = this.resolveQualifier(dataSourceDefinition);
        return (JdbcDatabaseConfig)Arc.container().instance(JdbcDatabaseConfig.class, new Annotation[]{qualifier}).get();
    }

    private Annotation resolveQualifier(DataSourceDefinition dataSourceDefinition) {
        if (dataSourceDefinition.isDefault) {
            return Default.Literal.INSTANCE;
        }
        return new DataSource.DataSourceLiteral(dataSourceDefinition.name);
    }
}

