/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.quarkus.jdbc;

import jakarta.transaction.TransactionManager;
import java.sql.Connection;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.jdbc.JdbcSession;
import org.komapper.quarkus.jdbc.QuarkusJdbcTransactionOperator;
import org.komapper.tx.core.TransactionOperator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lorg/komapper/quarkus/jdbc/QuarkusJdbcTransactionSession;", "Lorg/komapper/jdbc/JdbcSession;", "transactionManager", "Ljakarta/transaction/TransactionManager;", "dataSource", "Ljavax/sql/DataSource;", "<init>", "(Ljakarta/transaction/TransactionManager;Ljavax/sql/DataSource;)V", "getDataSource", "()Ljavax/sql/DataSource;", "transactionOperator", "Lorg/komapper/tx/core/TransactionOperator;", "getTransactionOperator", "()Lorg/komapper/tx/core/TransactionOperator;", "getConnection", "Ljava/sql/Connection;", "releaseConnection", "", "connection", "komapper-quarkus-jdbc"})
public final class QuarkusJdbcTransactionSession
implements JdbcSession {
    @NotNull
    private final DataSource dataSource;
    @NotNull
    private final TransactionOperator transactionOperator;

    public QuarkusJdbcTransactionSession(@NotNull TransactionManager transactionManager, @NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"transactionManager");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
        this.transactionOperator = new QuarkusJdbcTransactionOperator(transactionManager);
    }

    @NotNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public TransactionOperator getTransactionOperator() {
        return this.transactionOperator;
    }

    @NotNull
    public Connection getConnection() {
        Connection connection = this.getDataSource().getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        return connection;
    }

    public void releaseConnection(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.close();
    }

    public <R> R useConnection(@NotNull Function1<? super Connection, ? extends R> block) {
        return (R)JdbcSession.DefaultImpls.useConnection((JdbcSession)this, block);
    }
}

