/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.template.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KTypesJvm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.core.Value;
import org.komapper.template.expression.DefaultExprEvaluator;
import org.komapper.template.expression.ExprContext;
import org.komapper.template.expression.ExprEnvironment;
import org.komapper.template.expression.ExprEvaluator;
import org.komapper.template.expression.ExprException;
import org.komapper.template.expression.ExprLocation;
import org.komapper.template.expression.ExprNode;
import org.komapper.template.expression.ExprNodeFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u000267B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016JN\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152$\u0010\u0016\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002JF\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u001c\u0010\u0016\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JR\u0010\u001e\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190!\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010%\u001a\u0004\u0018\u00010\u00192\b\u0010&\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\u0006\u0010\"\u001a\u00020\b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J@\u0010)\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190!\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\u0010&\u001a\u0004\u0018\u00010\u0019H\u0002J4\u0010*\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0007H\u0002JB\u0010*\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u00100\u001a\u00020\u000e2\u0006\u0010-\u001a\u0002012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u00102\u001a\u00020\u000e2\u0006\u0010-\u001a\u0002032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u00104\u001a\u00020\u000e2\u0006\u0010-\u001a\u0002052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/komapper/template/expression/DefaultExprEvaluator;", "Lorg/komapper/template/expression/ExprEvaluator;", "exprNodeFactory", "Lorg/komapper/template/expression/ExprNodeFactory;", "exprEnvironment", "Lorg/komapper/template/expression/ExprEnvironment;", "classResolver", "Lkotlin/Function1;", "", "Ljava/lang/Class;", "(Lorg/komapper/template/expression/ExprNodeFactory;Lorg/komapper/template/expression/ExprEnvironment;Lkotlin/jvm/functions/Function1;)V", "clearCache", "", "compare", "Lorg/komapper/core/Value;", "location", "Lorg/komapper/template/expression/ExprLocation;", "leftNode", "Lorg/komapper/template/expression/ExprNode;", "rightNode", "ctx", "Lorg/komapper/template/expression/ExprContext;", "f", "Lkotlin/Function2;", "", "", "", "equal", "eval", "expression", "findFunction", "Lkotlin/Pair;", "Lkotlin/reflect/KFunction;", "", "name", "receiverType", "Lkotlin/reflect/KClass;", "receiver", "args", "findProperty", "Lkotlin/reflect/KProperty;", "findStaticFunction", "perform", "operand", "visit", "node", "visitClassRef", "Lorg/komapper/template/expression/ExprNode$ClassRef;", "visitFunction", "Lorg/komapper/template/expression/ExprNode$Function;", "visitProperty", "Lorg/komapper/template/expression/ExprNode$Property;", "visitValue", "Lorg/komapper/template/expression/ExprNode$Value;", "ArgList", "ClassRef", "komapper-template"})
public final class DefaultExprEvaluator
implements ExprEvaluator {
    @NotNull
    private final ExprNodeFactory exprNodeFactory;
    @NotNull
    private final ExprEnvironment exprEnvironment;
    @NotNull
    private final Function1<String, Class<?>> classResolver;

    public DefaultExprEvaluator(@NotNull ExprNodeFactory exprNodeFactory, @NotNull ExprEnvironment exprEnvironment, @NotNull Function1<? super String, ? extends Class<?>> classResolver) {
        Intrinsics.checkNotNullParameter((Object)exprNodeFactory, (String)"exprNodeFactory");
        Intrinsics.checkNotNullParameter((Object)exprEnvironment, (String)"exprEnvironment");
        Intrinsics.checkNotNullParameter(classResolver, (String)"classResolver");
        this.exprNodeFactory = exprNodeFactory;
        this.exprEnvironment = exprEnvironment;
        this.classResolver = classResolver;
    }

    public /* synthetic */ DefaultExprEvaluator(ExprNodeFactory exprNodeFactory, ExprEnvironment exprEnvironment, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(exprNodeFactory, exprEnvironment, function1);
    }

    @Override
    @NotNull
    public Value eval(@NotNull String expression, @NotNull ExprContext ctx) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ExprNode node = this.exprNodeFactory.get(expression);
        return this.visit(node, ctx);
    }

    private final Value visit(ExprNode node, ExprContext ctx) {
        Value value;
        ExprNode exprNode = node;
        if (exprNode instanceof ExprNode.Not) {
            value = this.perform(node.getLocation(), ((ExprNode.Not)node).getOperand(), ctx, (Function1<? super Boolean, Boolean>)((Function1)visit.1.INSTANCE));
        } else if (exprNode instanceof ExprNode.And) {
            value = this.perform(node.getLocation(), ((ExprNode.And)node).getLeft(), ((ExprNode.And)node).getRight(), ctx, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)visit.2.INSTANCE));
        } else if (exprNode instanceof ExprNode.Or) {
            value = this.perform(node.getLocation(), ((ExprNode.Or)node).getLeft(), ((ExprNode.Or)node).getRight(), ctx, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)visit.3.INSTANCE));
        } else if (exprNode instanceof ExprNode.Eq) {
            value = this.equal(node.getLocation(), ((ExprNode.Eq)node).getLeft(), ((ExprNode.Eq)node).getRight(), ctx, (Function2<Object, Object, Boolean>)((Function2)visit.4.INSTANCE));
        } else if (exprNode instanceof ExprNode.Ne) {
            value = this.equal(node.getLocation(), ((ExprNode.Ne)node).getLeft(), ((ExprNode.Ne)node).getRight(), ctx, (Function2<Object, Object, Boolean>)((Function2)visit.5.INSTANCE));
        } else if (exprNode instanceof ExprNode.Ge) {
            value = this.compare(node.getLocation(), ((ExprNode.Ge)node).getLeft(), ((ExprNode.Ge)node).getRight(), ctx, (Function2<? super Comparable<Object>, ? super Comparable<Object>, Boolean>)((Function2)visit.6.INSTANCE));
        } else if (exprNode instanceof ExprNode.Gt) {
            value = this.compare(node.getLocation(), ((ExprNode.Gt)node).getLeft(), ((ExprNode.Gt)node).getRight(), ctx, (Function2<? super Comparable<Object>, ? super Comparable<Object>, Boolean>)((Function2)visit.7.INSTANCE));
        } else if (exprNode instanceof ExprNode.Le) {
            value = this.compare(node.getLocation(), ((ExprNode.Le)node).getLeft(), ((ExprNode.Le)node).getRight(), ctx, (Function2<? super Comparable<Object>, ? super Comparable<Object>, Boolean>)((Function2)visit.8.INSTANCE));
        } else if (exprNode instanceof ExprNode.Lt) {
            value = this.compare(node.getLocation(), ((ExprNode.Lt)node).getLeft(), ((ExprNode.Lt)node).getRight(), ctx, (Function2<? super Comparable<Object>, ? super Comparable<Object>, Boolean>)((Function2)visit.9.INSTANCE));
        } else if (exprNode instanceof ExprNode.Literal) {
            value = new Value(((ExprNode.Literal)node).getValue(), ((ExprNode.Literal)node).getKlass(), false, 4, null);
        } else if (exprNode instanceof ExprNode.Comma) {
            Object object;
            Value it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((ExprNode.Comma)node).getNodeList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ExprNode exprNode2 = (ExprNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = this.visit((ExprNode)it, ctx);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Value)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = it.getAny();
                collection.add(object);
            }
            Collection collection2 = CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)new ArgList());
            boolean bl = false;
            boolean bl2 = false;
            ArgList it2 = (ArgList)collection2;
            boolean bl3 = false;
            value = new Value((Object)it2, Reflection.getOrCreateKotlinClass(List.class), false, 4, null);
        } else if (exprNode instanceof ExprNode.ClassRef) {
            value = this.visitClassRef((ExprNode.ClassRef)node, ctx);
        } else if (exprNode instanceof ExprNode.Value) {
            value = this.visitValue((ExprNode.Value)node, ctx);
        } else if (exprNode instanceof ExprNode.Property) {
            value = this.visitProperty((ExprNode.Property)node, ctx);
        } else if (exprNode instanceof ExprNode.Function) {
            value = this.visitFunction((ExprNode.Function)node, ctx);
        } else if (exprNode instanceof ExprNode.Empty) {
            value = new Value((Object)Unit.INSTANCE, Reflection.getOrCreateKotlinClass(Unit.class), false, 4, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return value;
    }

    private final Value perform(ExprLocation location, ExprNode operand, ExprContext ctx, Function1<? super Boolean, Boolean> f) {
        Value value = this.visit(operand, ctx);
        Object value2 = value.component1();
        DefaultExprEvaluator.perform$checkNull(operand.getLocation(), value2);
        if (!(value2 instanceof Boolean)) {
            throw new ExprException("Cannot perform the logical operator because the operands is not Boolean at " + location);
        }
        return new Value(f.invoke(value2), Reflection.getOrCreateKotlinClass(Boolean.TYPE), false, 4, null);
    }

    private final Value perform(ExprLocation location, ExprNode leftNode, ExprNode rightNode, ExprContext ctx, Function2<? super Boolean, ? super Boolean, Boolean> f) {
        Value value = this.visit(leftNode, ctx);
        Object left = value.component1();
        Value value2 = this.visit(rightNode, ctx);
        Object right = value2.component1();
        DefaultExprEvaluator.perform$checkNull-3(leftNode.getLocation(), left, "left");
        DefaultExprEvaluator.perform$checkNull-3(rightNode.getLocation(), right, "right");
        if (!(left instanceof Boolean) || !(right instanceof Boolean)) {
            throw new ExprException("Cannot perform the logical operator because either operands is not Boolean at " + location);
        }
        return new Value(f.invoke(left, right), Reflection.getOrCreateKotlinClass(Boolean.TYPE), false, 4, null);
    }

    private final Value equal(ExprLocation location, ExprNode leftNode, ExprNode rightNode, ExprContext ctx, Function2<Object, Object, Boolean> f) {
        Value value = this.visit(leftNode, ctx);
        Object left = value.component1();
        Value value2 = this.visit(rightNode, ctx);
        Object right = value2.component1();
        return new Value(f.invoke(left, right), Reflection.getOrCreateKotlinClass(Boolean.TYPE), false, 4, null);
    }

    private final Value compare(ExprLocation location, ExprNode leftNode, ExprNode rightNode, ExprContext ctx, Function2<? super Comparable<Object>, ? super Comparable<Object>, Boolean> f) {
        Value value = this.visit(leftNode, ctx);
        Object left = value.component1();
        Value value2 = this.visit(rightNode, ctx);
        Object right = value2.component1();
        DefaultExprEvaluator.compare$checkNull-4(leftNode.getLocation(), left, "left");
        DefaultExprEvaluator.compare$checkNull-4(rightNode.getLocation(), right, "right");
        try {
            if (left == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            }
            Comparable cfr_ignored_0 = (Comparable)left;
            if (right == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            }
            Comparable cfr_ignored_1 = (Comparable)right;
            return new Value(f.invoke(left, right), Reflection.getOrCreateKotlinClass(Boolean.TYPE), false, 4, null);
        }
        catch (ClassCastException e) {
            throw new ExprException("Cannot compare because the operands are not comparable to each other at " + location);
        }
    }

    private final Value visitClassRef(ExprNode.ClassRef node, ExprContext ctx) {
        Value value;
        Class clazz;
        try {
            clazz = (Class)this.classResolver.invoke((Object)node.getName());
        }
        catch (Exception cause) {
            throw new ExprException("Failed to resolve the class \"" + node.getName() + "\" at " + node.getLocation() + ". The cause is " + cause);
        }
        Class clazz2 = clazz;
        KClass klass = JvmClassMappingKt.getKotlinClass((Class)clazz2);
        if (klass.getObjectInstance() != null) {
            Object object = klass.getObjectInstance();
            Intrinsics.checkNotNull((Object)object);
            value = new Value(object);
        } else if (KClasses.getCompanionObjectInstance((KClass)klass) != null) {
            Object object = KClasses.getCompanionObjectInstance((KClass)klass);
            Intrinsics.checkNotNull((Object)object);
            value = new Value(object);
        } else if (clazz2.isEnum()) {
            value = new Value((Object)new ClassRef.EnumRef(clazz2), klass, false, 4, null);
        } else {
            String string = "The unsupported class \"" + klass.getQualifiedName() + "\" is referenced.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return value;
    }

    private final Value visitValue(ExprNode.Value node, ExprContext ctx) {
        Value value;
        Value value2 = ctx.getValueMap().get(node.getName());
        return value2 == null ? ((value = this.exprEnvironment.getCtx().get(node.getName())) == null ? new Value(null, Reflection.getOrCreateKotlinClass(Object.class), false, 4, null) : value) : value2;
    }

    private final Value visitProperty(ExprNode.Property node, ExprContext ctx) {
        Value value = this.visit(node.getReceiver(), ctx);
        Object receiver = value.component1();
        KClass receiverType = value.component2();
        if (receiver instanceof ClassRef.EnumRef) {
            Enum<?> element$iv;
            block9: {
                Enum<?>[] enumArray = ((ClassRef.EnumRef)receiver).getClazz().getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(enumArray, (String)"receiver.clazz.enumConstants");
                Enum<?>[] $this$first$iv = enumArray;
                boolean $i$f$first = false;
                Enum<?>[] enumArray2 = $this$first$iv;
                int n = enumArray2.length;
                for (int i = 0; i < n; ++i) {
                    Enum<?> it = element$iv = enumArray2[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)node.getName())) {
                        continue;
                    }
                    break block9;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Enum<?> enum_ = element$iv;
            Intrinsics.checkNotNullExpressionValue(enum_, (String)"enum");
            return new Value(enum_);
        }
        KProperty<?> $this$first$iv = this.findProperty(node.getName(), receiverType);
        if ($this$first$iv == null) {
            throw new ExprException("The property \"" + node.getName() + "\" is not found at " + node.getLocation());
        }
        KProperty<?> property = $this$first$iv;
        if (receiver == null && node.getSafeCall()) {
            return new Value(null, KTypesJvm.getJvmErasure((KType)property.getReturnType()), false, 4, null);
        }
        try {
            Object object;
            if (property.isConst() && !receiverType.isCompanion()) {
                object = property.call(new Object[0]);
            } else {
                Object[] objectArray = new Object[]{receiver};
                object = property.call(objectArray);
            }
            Object obj = object;
            return new Value(obj, KTypesJvm.getJvmErasure((KType)property.getReturnType()), false, 4, null);
        }
        catch (Exception cause) {
            throw new ExprException("Failed to call the property \"" + node.getName() + "\" at " + node.getLocation() + ". The cause is " + cause);
        }
    }

    private final KProperty<?> findProperty(String name, KClass<?> receiverType) {
        KProperty kProperty;
        Object v0;
        KProperty p0;
        boolean bl;
        Iterable iterable;
        boolean bl2;
        Iterable iterable2;
        block4: {
            iterable2 = KClasses.getMemberProperties(receiverType);
            bl2 = false;
            iterable = iterable2;
            bl = false;
            for (Object t : iterable) {
                p0 = (KProperty)t;
                boolean bl3 = false;
                if (!DefaultExprEvaluator.findProperty$predicate(name, p0)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        KProperty1 kProperty1 = v0;
        if (kProperty1 == null) {
            Object v1;
            block5: {
                iterable2 = this.exprEnvironment.getTopLevelPropertyExtensions();
                bl2 = false;
                iterable = iterable2;
                bl = false;
                for (Object t : iterable) {
                    p0 = (KProperty)t;
                    boolean bl4 = false;
                    if (!DefaultExprEvaluator.findProperty$predicate(name, p0)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            kProperty = v1;
        } else {
            kProperty = (KProperty)kProperty1;
        }
        return kProperty;
    }

    private final Value visitFunction(ExprNode.Function node, ExprContext ctx) {
        Value value;
        Value value2 = this.visit(node.getReceiver(), ctx);
        Object receiver = value2.component1();
        KClass receiverType = value2.component2();
        Value value3 = this.visit(node.getArgs(), ctx);
        Object args = value3.component1();
        if (receiver instanceof ClassRef) {
            Value value4;
            Pair<KFunction<?>, List<Object>> pair = this.findStaticFunction(node.getName(), receiverType, args);
            if (pair == null) {
                value4 = null;
            } else {
                Pair<KFunction<?>, List<Object>> pair2 = pair;
                boolean bl = false;
                boolean bl2 = false;
                Pair<KFunction<?>, List<Object>> $dstr$function$arguments = pair2;
                boolean bl3 = false;
                KFunction function = (KFunction)$dstr$function$arguments.component1();
                List arguments = (List)$dstr$function$arguments.component2();
                value4 = DefaultExprEvaluator.visitFunction$call(node, function, arguments);
            }
            Value value5 = value4;
            if (value5 == null) {
                throw new ExprException("The static function \"" + node.getName() + "\" is not found at " + node.getLocation());
            }
            value = value5;
        } else {
            Value value6;
            Pair<KFunction<?>, List<Object>> pair = this.findFunction(node.getName(), receiverType, receiver, args, ctx);
            if (pair == null) {
                value6 = null;
            } else {
                Pair<KFunction<?>, List<Object>> pair3 = pair;
                boolean bl = false;
                boolean bl4 = false;
                Pair<KFunction<?>, List<Object>> $dstr$function$arguments = pair3;
                boolean bl5 = false;
                KFunction function = (KFunction)$dstr$function$arguments.component1();
                List arguments = (List)$dstr$function$arguments.component2();
                value6 = receiver == null && node.getSafeCall() ? new Value(null, KTypesJvm.getJvmErasure((KType)function.getReturnType()), false, 4, null) : DefaultExprEvaluator.visitFunction$call(node, function, arguments);
            }
            Value value7 = value6;
            if (value7 == null) {
                throw new ExprException("The function \"" + node.getName() + "\" is not found at " + node.getLocation());
            }
            value = value7;
        }
        return value;
    }

    private final Pair<KFunction<?>, List<Object>> findStaticFunction(String name, KClass<?> receiverType, Object args) {
        Object object = args;
        List arguments = Intrinsics.areEqual((Object)object, (Object)Unit.INSTANCE) ? CollectionsKt.emptyList() : (object instanceof ArgList ? (List)args : CollectionsKt.listOf((Object)args));
        return DefaultExprEvaluator.findStaticFunction$pick(KClasses.getStaticFunctions(receiverType), name, arguments);
    }

    private final Pair<KFunction<?>, List<Object>> findFunction(String name, KClass<?> receiverType, Object receiver, Object args, ExprContext ctx) {
        Object[] objectArray;
        List list;
        Pair<KFunction<?>, List<Object>> pair = args;
        if (Intrinsics.areEqual((Object)pair, (Object)Unit.INSTANCE)) {
            list = CollectionsKt.listOf((Object)receiver);
        } else if (pair instanceof ArgList) {
            list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)receiver), (Iterable)((Iterable)args));
        } else {
            objectArray = new Object[]{receiver, args};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List arguments = list;
        pair = DefaultExprEvaluator.findFunction$pick-15(KClasses.getMemberFunctions(receiverType), name, arguments);
        return pair == null ? ((objectArray = DefaultExprEvaluator.findFunction$pick-15((Collection)this.exprEnvironment.getTopLevelFunctionExtensions(), name, arguments)) == null ? DefaultExprEvaluator.findFunction$pick-15(KClasses.getMemberExtensionFunctions((KClass)Reflection.getOrCreateKotlinClass(ctx.getFunctionExtensions().getClass())), name, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)ctx.getFunctionExtensions()), (Iterable)arguments)) : objectArray) : pair;
    }

    @Override
    public void clearCache() {
        this.exprNodeFactory.clearCache();
    }

    private static final void perform$checkNull(ExprLocation location, Object value) {
        if (value != null) {
            return;
        }
        throw new ExprException("Cannot perform the logical operator because the operand is null at " + location);
    }

    private static final void perform$checkNull-3(ExprLocation location, Object value, String which) {
        if (value != null) {
            return;
        }
        throw new ExprException("Cannot perform the logical operator because the " + which + " operand is null at " + location);
    }

    private static final void compare$checkNull-4(ExprLocation location, Object value, String which) {
        if (value != null) {
            return;
        }
        throw new ExprException("Cannot compare because the " + which + " operand is null at " + location);
    }

    private static final boolean findProperty$predicate(String $name, KProperty<?> property) {
        return Intrinsics.areEqual((Object)$name, (Object)property.getName()) && KCallables.getValueParameters((KCallable)((KCallable)property)).isEmpty();
    }

    private static final Value visitFunction$call(ExprNode.Function $node, KFunction<?> function, List<? extends Object> arguments) {
        try {
            Collection $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray2 = objectArray;
            return new Value(function.call(Arrays.copyOf(objectArray2, objectArray2.length)), KTypesJvm.getJvmErasure((KType)function.getReturnType()), false, 4, null);
        }
        catch (Exception cause) {
            throw new ExprException("Failed to call the function \"" + $node.getName() + "\" at " + $node.getLocation() + ". The cause is " + cause);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<KFunction<?>, List<Object>> findStaticFunction$pick(Collection<? extends KFunction<?>> $this$findStaticFunction_u24pick, String $name, List<? extends Object> arguments) {
        void $this$mapTo$iv$iv;
        KFunction function;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$findStaticFunction_u24pick;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block7: {
                function = (KFunction)element$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)$name, (Object)function.getName()) && arguments.size() == function.getParameters().size()) {
                    Iterable $this$all$iv = CollectionsKt.zip((Iterable)arguments, (Iterable)function.getParameters());
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            Pair $dstr$argument$param = (Pair)element$iv;
                            boolean bl3 = false;
                            Object argument = $dstr$argument$param.component1();
                            KParameter param = (KParameter)$dstr$argument$param.component2();
                            if (argument == null || KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(argument.getClass()), (KClass)KTypesJvm.getJvmErasure((KType)param.getType()))) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                } else {
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            function = (KFunction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, arguments);
            collection.add(pair);
        }
        return (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<KFunction<?>, List<Object>> findFunction$pick-15(Collection<? extends KFunction<?>> $this$findFunction_u24pick_u2d15, String $name, List<? extends Object> arguments) {
        void $this$mapTo$iv$iv;
        KFunction function;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$findFunction_u24pick_u2d15;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block7: {
                function = (KFunction)element$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)$name, (Object)function.getName()) && arguments.size() == function.getParameters().size()) {
                    Iterable $this$all$iv = CollectionsKt.zip((Iterable)arguments, (Iterable)function.getParameters());
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            Pair $dstr$argument$param = (Pair)element$iv;
                            boolean bl3 = false;
                            Object argument = $dstr$argument$param.component1();
                            KParameter param = (KParameter)$dstr$argument$param.component2();
                            if (argument == null || KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(argument.getClass()), (KClass)KTypesJvm.getJvmErasure((KType)param.getType()))) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                } else {
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            function = (KFunction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, arguments);
            collection.add(pair);
        }
        return (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/komapper/template/expression/DefaultExprEvaluator$ArgList;", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "()V", "komapper-template"})
    public static final class ArgList
    extends ArrayList<Object> {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0001\b\u00a8\u0006\t"}, d2={"Lorg/komapper/template/expression/DefaultExprEvaluator$ClassRef;", "", "()V", "clazz", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "EnumRef", "Lorg/komapper/template/expression/DefaultExprEvaluator$ClassRef$EnumRef;", "komapper-template"})
    public static abstract class ClassRef {
        private ClassRef() {
        }

        @NotNull
        public abstract Class<?> getClazz();

        public /* synthetic */ ClassRef(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u00c6\u0003J\u001d\u0010\t\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001e\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/komapper/template/expression/DefaultExprEvaluator$ClassRef$EnumRef;", "Lorg/komapper/template/expression/DefaultExprEvaluator$ClassRef;", "clazz", "Ljava/lang/Class;", "", "(Ljava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "komapper-template"})
        public static final class EnumRef
        extends ClassRef {
            @NotNull
            private final Class<Enum<?>> clazz;

            public EnumRef(@NotNull Class<Enum<?>> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                super(null);
                this.clazz = clazz;
            }

            @NotNull
            public Class<Enum<?>> getClazz() {
                return this.clazz;
            }

            @NotNull
            public final Class<Enum<?>> component1() {
                return this.getClazz();
            }

            @NotNull
            public final EnumRef copy(@NotNull Class<Enum<?>> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                return new EnumRef(clazz);
            }

            public static /* synthetic */ EnumRef copy$default(EnumRef enumRef, Class clazz, int n, Object object) {
                if ((n & 1) != 0) {
                    clazz = enumRef.getClazz();
                }
                return enumRef.copy(clazz);
            }

            @NotNull
            public String toString() {
                return "EnumRef(clazz=" + this.getClazz() + ")";
            }

            public int hashCode() {
                return this.getClazz().hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EnumRef)) {
                    return false;
                }
                EnumRef enumRef = (EnumRef)other;
                return Intrinsics.areEqual(this.getClazz(), enumRef.getClazz());
            }
        }
    }
}

