/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.template.expression;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.komapper.template.expression.AndReducer;
import org.komapper.template.expression.CommaReducer;
import org.komapper.template.expression.EqReducer;
import org.komapper.template.expression.ExprException;
import org.komapper.template.expression.ExprLocation;
import org.komapper.template.expression.ExprNode;
import org.komapper.template.expression.ExprReducer;
import org.komapper.template.expression.ExprTokenType;
import org.komapper.template.expression.ExprTokenizer;
import org.komapper.template.expression.FunctionReducer;
import org.komapper.template.expression.GeReducer;
import org.komapper.template.expression.GtReducer;
import org.komapper.template.expression.LeReducer;
import org.komapper.template.expression.LtReducer;
import org.komapper.template.expression.NeReducer;
import org.komapper.template.expression.NotReducer;
import org.komapper.template.expression.OrReducer;
import org.komapper.template.expression.PropertyReducer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u0012\u0010\u001b\u001a\u00020\u00152\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0002J\b\u0010 \u001a\u00020\u0015H\u0002J\b\u0010!\u001a\u00020\u0015H\u0002J\u0012\u0010\"\u001a\u00020\u00152\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020\u0015H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u000fH\u0002J\b\u0010)\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/komapper/template/expression/ExprParser;", "", "expression", "", "tokenizer", "Lorg/komapper/template/expression/ExprTokenizer;", "(Ljava/lang/String;Lorg/komapper/template/expression/ExprTokenizer;)V", "location", "Lorg/komapper/template/expression/ExprLocation;", "getLocation", "()Lorg/komapper/template/expression/ExprLocation;", "nodes", "Ljava/util/Deque;", "Lorg/komapper/template/expression/ExprNode;", "reducers", "Lorg/komapper/template/expression/ExprReducer;", "token", "tokenType", "Lorg/komapper/template/expression/ExprTokenType;", "parse", "parseBigDecimalLiteral", "", "parseCharLiteral", "parseClassRef", "parseDoubleLiteral", "parseFalseLiteral", "parseFloatLiteral", "parseFunction", "safeCall", "", "parseIntLiteral", "parseLongLiteral", "parseNullLiteral", "parseParen", "parseProperty", "parseStringLiteral", "parseTrueLiteral", "parseValue", "pushReducer", "reducer", "reduce", "reduceAll", "komapper-template"})
public final class ExprParser {
    @NotNull
    private final String expression;
    @NotNull
    private final ExprTokenizer tokenizer;
    @NotNull
    private final Deque<ExprNode> nodes;
    @NotNull
    private final Deque<ExprReducer> reducers;
    @NotNull
    private ExprTokenType tokenType;
    @NotNull
    private String token;

    public ExprParser(@NotNull String expression, @NotNull ExprTokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.expression = expression;
        this.tokenizer = tokenizer;
        this.nodes = new LinkedList();
        this.reducers = new LinkedList();
        this.tokenType = ExprTokenType.EOE;
        this.token = "";
    }

    public /* synthetic */ ExprParser(String string, ExprTokenizer exprTokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            exprTokenizer = new ExprTokenizer(string);
        }
        this(string, exprTokenizer);
    }

    private final ExprLocation getLocation() {
        return this.tokenizer.getLocation();
    }

    @NotNull
    public final ExprNode parse() {
        ExprTokenType exprTokenType;
        block34: while (true) {
            this.tokenType = this.tokenizer.next();
            this.token = this.tokenizer.getToken();
            exprTokenType = this.tokenType;
            int n = WhenMappings.$EnumSwitchMapping$0[exprTokenType.ordinal()];
            switch (n) {
                case 1: {
                    break block34;
                }
                case 2: {
                    this.parseParen();
                    continue block34;
                }
                case 3: {
                    break block34;
                }
                case 4: {
                    continue block34;
                }
                case 5: {
                    this.parseClassRef();
                    continue block34;
                }
                case 6: {
                    this.parseValue();
                    continue block34;
                }
                case 7: {
                    this.parseCharLiteral();
                    continue block34;
                }
                case 8: {
                    this.parseStringLiteral();
                    continue block34;
                }
                case 9: {
                    this.parseIntLiteral();
                    continue block34;
                }
                case 10: {
                    this.parseLongLiteral();
                    continue block34;
                }
                case 11: {
                    this.parseFloatLiteral();
                    continue block34;
                }
                case 12: {
                    this.parseDoubleLiteral();
                    continue block34;
                }
                case 13: {
                    this.parseBigDecimalLiteral();
                    continue block34;
                }
                case 14: {
                    this.parseTrueLiteral();
                    continue block34;
                }
                case 15: {
                    this.parseFalseLiteral();
                    continue block34;
                }
                case 16: {
                    this.parseNullLiteral();
                    continue block34;
                }
                case 17: {
                    this.pushReducer(new NotReducer(this.getLocation()));
                    continue block34;
                }
                case 18: {
                    this.pushReducer(new AndReducer(this.getLocation()));
                    continue block34;
                }
                case 19: {
                    this.pushReducer(new OrReducer(this.getLocation()));
                    continue block34;
                }
                case 20: {
                    this.pushReducer(new CommaReducer(this.getLocation()));
                    continue block34;
                }
                case 21: {
                    this.pushReducer(new EqReducer(this.getLocation()));
                    continue block34;
                }
                case 22: {
                    this.pushReducer(new NeReducer(this.getLocation()));
                    continue block34;
                }
                case 23: {
                    this.pushReducer(new GeReducer(this.getLocation()));
                    continue block34;
                }
                case 24: {
                    this.pushReducer(new LeReducer(this.getLocation()));
                    continue block34;
                }
                case 25: {
                    this.pushReducer(new GtReducer(this.getLocation()));
                    continue block34;
                }
                case 26: {
                    this.pushReducer(new LtReducer(this.getLocation()));
                    continue block34;
                }
                case 27: {
                    this.parseFunction(true);
                    continue block34;
                }
                case 28: {
                    this.parseProperty(true);
                    continue block34;
                }
                case 29: {
                    ExprParser.parseFunction$default(this, false, 1, null);
                    continue block34;
                }
                case 30: {
                    ExprParser.parseProperty$default(this, false, 1, null);
                    continue block34;
                }
                case 31: {
                    throw new ExprException("The illegal number literal \"" + this.token + "\" is found at " + this.getLocation());
                }
                case 32: {
                    throw new ExprException("The token \"" + this.token + "\" is not supported at " + this.getLocation());
                }
                default: {
                    continue block34;
                }
            }
            break;
        }
        this.reduceAll();
        ExprNode node = this.nodes.poll();
        return node == null ? (ExprNode)new ExprNode.Empty(this.getLocation()) : exprTokenType;
    }

    private final void parseClassRef() {
        String string = this.token;
        int n = 1;
        int n2 = this.token.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String name = string3;
        ExprNode.ClassRef node = new ExprNode.ClassRef(this.getLocation(), name);
        this.nodes.push(node);
    }

    private final void parseValue() {
        ExprNode.Value node = new ExprNode.Value(this.getLocation(), this.token);
        this.nodes.push(node);
    }

    private final void parseParen() {
        ExprParser parser = new ExprParser(this.expression, this.tokenizer);
        ExprNode node = parser.parse();
        if (parser.tokenType != ExprTokenType.CLOSE_PAREN) {
            throw new ExprException("The close paren is not found at " + this.getLocation());
        }
        this.nodes.push(node);
    }

    private final void parseStringLiteral() {
        String string = this.token;
        int n = 1;
        int n2 = this.token.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String value = string3;
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), value, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(String.class));
        this.nodes.push(node);
    }

    private final void parseCharLiteral() {
        char value = this.token.charAt(1);
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), Character.valueOf(value), (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Character.TYPE));
        this.nodes.push(node);
    }

    private final void parseIntLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length();
        String string = this.token;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Integer value = Integer.valueOf(string3);
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), value, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Integer.TYPE));
        this.nodes.push(node);
    }

    private final void parseLongLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length() - 1;
        String string = this.token;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Long value = Long.valueOf(string3);
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), value, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Long.TYPE));
        this.nodes.push(node);
    }

    private final void parseFloatLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length() - 1;
        String string = this.token;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Float value = Float.valueOf(string3);
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), value, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Float.TYPE));
        this.nodes.push(node);
    }

    private final void parseDoubleLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length() - 1;
        String string = this.token;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Double value = Double.valueOf(string3);
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), value, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Double.TYPE));
        this.nodes.push(node);
    }

    private final void parseBigDecimalLiteral() {
        int start = 0;
        int end = this.token.length() - 1;
        String string = this.token;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        BigDecimal value = new BigDecimal(string3);
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), value, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(BigDecimal.class));
        this.nodes.push(node);
    }

    private final void parseTrueLiteral() {
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), true, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Boolean.TYPE));
        this.nodes.push(node);
    }

    private final void parseFalseLiteral() {
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), false, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Boolean.TYPE));
        this.nodes.push(node);
    }

    private final void parseNullLiteral() {
        ExprNode.Literal node = new ExprNode.Literal(this.getLocation(), null, (KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Object.class));
        this.nodes.push(node);
    }

    private final void parseFunction(boolean safeCall) {
        String string = this.token;
        int n = safeCall ? 2 : 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String name = string3;
        FunctionReducer reducer = new FunctionReducer(this.getLocation(), name, safeCall);
        this.tokenType = this.tokenizer.next();
        this.parseParen();
        this.pushReducer(reducer);
    }

    static /* synthetic */ void parseFunction$default(ExprParser exprParser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        exprParser.parseFunction(bl);
    }

    private final void parseProperty(boolean safeCall) {
        String string = this.token;
        int n = safeCall ? 2 : 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String name = string3;
        PropertyReducer reducer = new PropertyReducer(this.getLocation(), name, safeCall);
        this.pushReducer(reducer);
    }

    static /* synthetic */ void parseProperty$default(ExprParser exprParser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        exprParser.parseProperty(bl);
    }

    private final void pushReducer(ExprReducer reducer) {
        ExprReducer first;
        Collection collection = this.reducers;
        boolean bl = false;
        if (!collection.isEmpty() && (first = this.reducers.peek()).getPriority() > reducer.getPriority()) {
            Iterator<ExprReducer> iterator = this.reducers.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"reducers.iterator()");
            Iterator<ExprReducer> it = iterator;
            while (it.hasNext()) {
                ExprReducer r = it.next();
                if (r.getPriority() <= reducer.getPriority()) continue;
                it.remove();
                Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                this.reduce(r);
            }
        }
        this.reducers.push(reducer);
    }

    private final void reduceAll() {
        Iterator<ExprReducer> iterator = this.reducers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"reducers.iterator()");
        Iterator<ExprReducer> it = iterator;
        while (it.hasNext()) {
            ExprReducer reducer = it.next();
            it.remove();
            Intrinsics.checkNotNullExpressionValue((Object)reducer, (String)"reducer");
            this.reduce(reducer);
        }
    }

    private final void reduce(ExprReducer reducer) {
        ExprNode node = reducer.reduce(this.nodes);
        this.nodes.push(node);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExprTokenType.values().length];
            nArray[ExprTokenType.EOE.ordinal()] = 1;
            nArray[ExprTokenType.OPEN_PAREN.ordinal()] = 2;
            nArray[ExprTokenType.CLOSE_PAREN.ordinal()] = 3;
            nArray[ExprTokenType.WHITESPACE.ordinal()] = 4;
            nArray[ExprTokenType.CLASS_REF.ordinal()] = 5;
            nArray[ExprTokenType.VALUE.ordinal()] = 6;
            nArray[ExprTokenType.CHAR.ordinal()] = 7;
            nArray[ExprTokenType.STRING.ordinal()] = 8;
            nArray[ExprTokenType.INT.ordinal()] = 9;
            nArray[ExprTokenType.LONG.ordinal()] = 10;
            nArray[ExprTokenType.FLOAT.ordinal()] = 11;
            nArray[ExprTokenType.DOUBLE.ordinal()] = 12;
            nArray[ExprTokenType.BIG_DECIMAL.ordinal()] = 13;
            nArray[ExprTokenType.TRUE.ordinal()] = 14;
            nArray[ExprTokenType.FALSE.ordinal()] = 15;
            nArray[ExprTokenType.NULL.ordinal()] = 16;
            nArray[ExprTokenType.NOT.ordinal()] = 17;
            nArray[ExprTokenType.AND.ordinal()] = 18;
            nArray[ExprTokenType.OR.ordinal()] = 19;
            nArray[ExprTokenType.COMMA.ordinal()] = 20;
            nArray[ExprTokenType.EQ.ordinal()] = 21;
            nArray[ExprTokenType.NE.ordinal()] = 22;
            nArray[ExprTokenType.GE.ordinal()] = 23;
            nArray[ExprTokenType.LE.ordinal()] = 24;
            nArray[ExprTokenType.GT.ordinal()] = 25;
            nArray[ExprTokenType.LT.ordinal()] = 26;
            nArray[ExprTokenType.SAFE_CALL_FUNCTION.ordinal()] = 27;
            nArray[ExprTokenType.SAFE_CALL_PROPERTY.ordinal()] = 28;
            nArray[ExprTokenType.FUNCTION.ordinal()] = 29;
            nArray[ExprTokenType.PROPERTY.ordinal()] = 30;
            nArray[ExprTokenType.ILLEGAL_NUMBER.ordinal()] = 31;
            nArray[ExprTokenType.OTHER.ordinal()] = 32;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

