/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.template.expression;

import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.komapper.template.expression.ExprException;
import org.komapper.template.expression.ExprLocation;
import org.komapper.template.expression.ExprTokenType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0006H\u0002J\t\u0010\u0018\u001a\u00020\u0016H\u0086\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R\u0016\u0010\u0014\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/komapper/template/expression/ExprTokenizer;", "", "expression", "", "(Ljava/lang/String;)V", "binaryOpAvailable", "", "buf", "Ljava/nio/CharBuffer;", "kotlin.jvm.PlatformType", "location", "Lorg/komapper/template/expression/ExprLocation;", "getLocation", "()Lorg/komapper/template/expression/ExprLocation;", "lookahead", "", "token", "getToken", "()Ljava/lang/String;", "setToken", "tokenBuf", "type", "Lorg/komapper/template/expression/ExprTokenType;", "isWordTerminated", "next", "read", "", "readFiveChars", "c", "readFourChars", "readNumber", "readOneChar", "", "readThreeChars", "readTwoChars", "Companion", "komapper-template"})
public final class ExprTokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String expression;
    @NotNull
    private final char[] lookahead;
    private final CharBuffer buf;
    private final CharBuffer tokenBuf;
    private boolean binaryOpAvailable;
    @NotNull
    private ExprTokenType type;
    @NotNull
    private String token;
    public static final int LOOKAHEAD_SIZE = 5;

    public ExprTokenizer(@NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.expression = expression;
        this.lookahead = new char[5];
        this.buf = CharBuffer.wrap(this.expression);
        this.tokenBuf = this.buf.asReadOnlyBuffer();
        this.type = ExprTokenType.EOE;
        this.token = "";
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    public final void setToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.token = string;
    }

    @NotNull
    public final ExprLocation getLocation() {
        return new ExprLocation(this.expression, this.buf.position());
    }

    @NotNull
    public final ExprTokenType next() {
        this.read();
        this.tokenBuf.limit(this.buf.position());
        String string = this.tokenBuf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokenBuf.toString()");
        this.token = string;
        this.tokenBuf.position(this.buf.position());
        return this.type;
    }

    private final void read() {
        int length = RangesKt.coerceAtMost((int)this.buf.remaining(), (int)5);
        this.buf.get(this.lookahead, 0, length);
        int n = length;
        switch (n) {
            case 5: {
                this.readFiveChars(this.lookahead);
                break;
            }
            case 4: {
                this.readFourChars(this.lookahead);
                break;
            }
            case 3: {
                this.readThreeChars(this.lookahead);
                break;
            }
            case 2: {
                this.readTwoChars(this.lookahead);
                break;
            }
            case 1: {
                this.readOneChar(this.lookahead[0]);
                break;
            }
            case 0: {
                this.type = ExprTokenType.EOE;
                break;
            }
            default: {
                Integer n2 = length;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(((Object)n2).toString());
            }
        }
    }

    private final void readFiveChars(char[] c) {
        if (c[0] == 'f' && c[1] == 'a' && c[2] == 'l' && c[3] == 's' && c[4] == 'e' && this.isWordTerminated()) {
            this.type = ExprTokenType.FALSE;
            this.binaryOpAvailable = true;
            return;
        }
        this.buf.position(this.buf.position() - 1);
        this.readFourChars(c);
    }

    private final void readFourChars(char[] c) {
        if (c[0] == 'n' && c[1] == 'u' && c[2] == 'l' && c[3] == 'l') {
            if (this.isWordTerminated()) {
                this.type = ExprTokenType.NULL;
                this.binaryOpAvailable = true;
                return;
            }
        } else if (c[0] == 't' && c[1] == 'r' && c[2] == 'u' && c[3] == 'e' && this.isWordTerminated()) {
            this.type = ExprTokenType.TRUE;
            this.binaryOpAvailable = true;
            return;
        }
        this.buf.position(this.buf.position() - 1);
        this.readThreeChars(c);
    }

    private final void readThreeChars(char[] c) {
        this.buf.position(this.buf.position() - 1);
        this.readTwoChars(c);
    }

    private final void readTwoChars(char[] c) {
        if (this.binaryOpAvailable) {
            if (c[0] == '&' && c[1] == '&') {
                this.type = ExprTokenType.AND;
                this.binaryOpAvailable = false;
                return;
            }
            if (c[0] == '|' && c[1] == '|') {
                this.type = ExprTokenType.OR;
                this.binaryOpAvailable = false;
                return;
            }
            if (c[0] == '=' && c[1] == '=') {
                this.type = ExprTokenType.EQ;
                this.binaryOpAvailable = false;
                return;
            }
            if (c[0] == '!' && c[1] == '=') {
                this.type = ExprTokenType.NE;
                this.binaryOpAvailable = false;
                return;
            }
            if (c[0] == '>' && c[1] == '=') {
                this.type = ExprTokenType.GE;
                this.binaryOpAvailable = false;
                return;
            }
            if (c[0] == '<' && c[1] == '=') {
                this.type = ExprTokenType.LE;
                this.binaryOpAvailable = false;
                return;
            }
        }
        if (c[0] == '?' && c[1] == '.') {
            char c1;
            this.type = ExprTokenType.SAFE_CALL_PROPERTY;
            this.binaryOpAvailable = true;
            if (!this.buf.hasRemaining()) {
                throw new ExprException("Either property or function name must follow the safe call operator at " + this.getLocation());
            }
            this.buf.mark();
            char c2 = c1 = this.buf.get();
            char c3 = '\u0000';
            if (Character.isJavaIdentifierStart(c2)) {
                while (this.buf.hasRemaining()) {
                    char c22;
                    this.buf.mark();
                    c3 = c22 = this.buf.get();
                    boolean bl = false;
                    if (Character.isJavaIdentifierPart(c3)) continue;
                    if (c22 == '(') {
                        this.type = ExprTokenType.SAFE_CALL_FUNCTION;
                        this.binaryOpAvailable = false;
                    }
                    this.buf.reset();
                    return;
                }
            } else {
                throw new ExprException("The character \"" + c1 + "\" is illegal as an identifier start at " + this.getLocation());
            }
            return;
        }
        this.buf.position(this.buf.position() - 1);
        this.readOneChar(c[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void readOneChar(char c) {
        if (this.binaryOpAvailable) {
            if (c == '>') {
                this.type = ExprTokenType.GT;
                this.binaryOpAvailable = false;
                return;
            }
            if (c == '<') {
                this.type = ExprTokenType.LT;
                this.binaryOpAvailable = false;
                return;
            }
        }
        if (CharsKt.isWhitespace((char)c)) {
            this.type = ExprTokenType.WHITESPACE;
            return;
        }
        if (c == ',') {
            this.type = ExprTokenType.COMMA;
            return;
        }
        if (c == '(') {
            this.type = ExprTokenType.OPEN_PAREN;
            return;
        }
        if (c == ')') {
            this.type = ExprTokenType.CLOSE_PAREN;
            this.binaryOpAvailable = true;
            return;
        }
        if (c == '!') {
            this.type = ExprTokenType.NOT;
            return;
        }
        if (c == '\'') {
            char c2;
            this.type = ExprTokenType.CHAR;
            if (!this.buf.hasRemaining()) throw new ExprException("The end of single quotation mark is not found at " + this.getLocation());
            this.buf.get();
            if (!this.buf.hasRemaining() || (c2 = this.buf.get()) != '\'') throw new ExprException("The end of single quotation mark is not found at " + this.getLocation());
            this.binaryOpAvailable = true;
            return;
        }
        if (c == '\"') {
            this.type = ExprTokenType.STRING;
            boolean closed = false;
            while (this.buf.hasRemaining()) {
                char c1 = this.buf.get();
                if (c1 != '\"') continue;
                if (this.buf.hasRemaining()) {
                    this.buf.mark();
                    char c2 = this.buf.get();
                    if (c2 == '\"') continue;
                    this.buf.reset();
                    closed = true;
                    break;
                }
                closed = true;
            }
            if (!closed) {
                throw new ExprException("The end of double quotation mark is not found at " + this.getLocation());
            }
            this.binaryOpAvailable = true;
            return;
        }
        if (c == '@') {
            this.type = ExprTokenType.CLASS_REF;
            boolean closed = false;
            while (this.buf.hasRemaining()) {
                char c12 = this.buf.get();
                if (c12 != '@') continue;
                closed = true;
                break;
            }
            if (!closed) {
                throw new ExprException("The end of at sign is not found at " + this.getLocation());
            }
            this.binaryOpAvailable = true;
            return;
        }
        if (c == '+' || c == '-') {
            this.buf.mark();
            if (this.buf.hasRemaining()) {
                char c1;
                char c12 = c1 = this.buf.get();
                boolean bl = false;
                if (Character.isDigit(c12)) {
                    this.readNumber();
                    return;
                }
                this.buf.reset();
            }
            this.type = ExprTokenType.ILLEGAL_NUMBER;
            return;
        }
        char c1 = c;
        char c12 = '\u0000';
        if (Character.isDigit(c1)) {
            this.readNumber();
            return;
        }
        c1 = c;
        c12 = '\u0000';
        if (Character.isJavaIdentifierStart(c1)) {
            this.type = ExprTokenType.VALUE;
            this.binaryOpAvailable = true;
            while (this.buf.hasRemaining()) {
                this.buf.mark();
                c12 = c1 = this.buf.get();
                boolean bl = false;
                if (Character.isJavaIdentifierPart(c12)) continue;
                this.buf.reset();
                return;
            }
            return;
        }
        if (c == '.') {
            this.type = ExprTokenType.PROPERTY;
            this.binaryOpAvailable = true;
            if (!this.buf.hasRemaining()) {
                throw new ExprException("Either property or function name must follow the dot at " + this.getLocation());
            }
            this.buf.mark();
            c12 = c1 = this.buf.get();
            char c2 = '\u0000';
            if (!Character.isJavaIdentifierStart(c12)) throw new ExprException("The character \"" + c1 + "\" is illegal as an identifier start at " + this.getLocation());
            while (this.buf.hasRemaining()) {
                char c22;
                this.buf.mark();
                c2 = c22 = this.buf.get();
                boolean bl = false;
                if (Character.isJavaIdentifierPart(c2)) continue;
                if (c22 == '(') {
                    this.type = ExprTokenType.FUNCTION;
                    this.binaryOpAvailable = false;
                }
                this.buf.reset();
                return;
            }
            return;
        } else {
            this.type = ExprTokenType.OTHER;
        }
    }

    private final void readNumber() {
        this.type = ExprTokenType.INT;
        boolean decimal = false;
        while (this.buf.hasRemaining()) {
            char c;
            this.buf.mark();
            char c2 = c = this.buf.get();
            char c3 = '\u0000';
            if (Character.isDigit(c2)) continue;
            if (c == '.') {
                if (decimal) {
                    this.type = ExprTokenType.ILLEGAL_NUMBER;
                    return;
                }
                decimal = true;
                if (this.buf.hasRemaining()) {
                    char c22;
                    c3 = c22 = this.buf.get();
                    boolean bl = false;
                    if (Character.isDigit(c3)) continue;
                    this.type = ExprTokenType.ILLEGAL_NUMBER;
                    return;
                }
                this.type = ExprTokenType.ILLEGAL_NUMBER;
                return;
            }
            if (c == 'F') {
                this.type = ExprTokenType.FLOAT;
                break;
            }
            if (c == 'D') {
                this.type = ExprTokenType.DOUBLE;
                break;
            }
            if (c == 'L') {
                this.type = ExprTokenType.LONG;
                break;
            }
            if (c == 'B') {
                this.type = ExprTokenType.BIG_DECIMAL;
                break;
            }
            this.buf.reset();
            break;
        }
        if (!this.isWordTerminated()) {
            this.type = ExprTokenType.ILLEGAL_NUMBER;
        }
        this.binaryOpAvailable = true;
    }

    private final boolean isWordTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c;
            char c2 = c = this.buf.get();
            boolean bl = false;
            if (!Character.isJavaIdentifierPart(c2)) {
                this.buf.reset();
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/komapper/template/expression/ExprTokenizer$Companion;", "", "()V", "LOOKAHEAD_SIZE", "", "komapper-template"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

