/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.template.sql;

import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komapper.template.sql.BlockReducer;
import org.komapper.template.sql.SqlException;
import org.komapper.template.sql.SqlLocation;
import org.komapper.template.sql.SqlNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/komapper/template/sql/IfBlockReducer;", "Lorg/komapper/template/sql/BlockReducer;", "location", "Lorg/komapper/template/sql/SqlLocation;", "(Lorg/komapper/template/sql/SqlLocation;)V", "addNode", "", "node", "Lorg/komapper/template/sql/SqlNode;", "getElseDirective", "Lorg/komapper/template/sql/SqlNode$ElseDirective;", "getElseifDirectives", "", "Lorg/komapper/template/sql/SqlNode$ElseifDirective;", "getEndDirective", "Lorg/komapper/template/sql/SqlNode$EndDirective;", "getIfDirective", "Lorg/komapper/template/sql/SqlNode$IfDirective;", "reduce", "komapper-template"})
public final class IfBlockReducer
extends BlockReducer {
    @NotNull
    private final SqlLocation location;

    public IfBlockReducer(@NotNull SqlLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.location = location;
    }

    @Override
    public boolean addNode(@NotNull SqlNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SqlNode sqlNode = node;
        if (!(((sqlNode instanceof SqlNode.IfDirective ? true : sqlNode instanceof SqlNode.ElseifDirective) ? true : sqlNode instanceof SqlNode.ElseDirective) ? true : sqlNode instanceof SqlNode.EndDirective)) {
            boolean bl = false;
            throw (Throwable)new IllegalStateException(node.toString());
        }
        return super.addNode(node);
    }

    @Override
    @NotNull
    public SqlNode reduce() {
        SqlNode.IfDirective ifDirective = this.getIfDirective();
        List<SqlNode.ElseifDirective> elseifDirectives = this.getElseifDirectives();
        SqlNode.ElseDirective elseDirective = this.getElseDirective();
        SqlNode.EndDirective endDirect = this.getEndDirective();
        return new SqlNode.IfBlock(ifDirective, elseifDirectives, elseDirective, endDirect);
    }

    private final SqlNode.IfDirective getIfDirective() {
        SqlNode sqlNode = this.getNodeList().poll();
        SqlNode.IfDirective node = sqlNode instanceof SqlNode.IfDirective ? (SqlNode.IfDirective)sqlNode : null;
        sqlNode = node;
        if (sqlNode == null) {
            String string = "IfDirective is not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return sqlNode;
    }

    private final List<SqlNode.ElseifDirective> getElseifDirectives() {
        LinkedList<SqlNode.ElseifDirective> list = new LinkedList<SqlNode.ElseifDirective>();
        while (true) {
            SqlNode sqlNode;
            SqlNode.ElseifDirective node;
            SqlNode.ElseifDirective elseifDirective = node = (sqlNode = this.getNodeList().peek()) instanceof SqlNode.ElseifDirective ? (SqlNode.ElseifDirective)sqlNode : null;
            if (node == null) break;
            this.getNodeList().pop();
            list.add(node);
        }
        return list;
    }

    private final SqlNode.ElseDirective getElseDirective() {
        SqlNode.ElseDirective node;
        SqlNode sqlNode = this.getNodeList().peek();
        SqlNode.ElseDirective elseDirective = node = sqlNode instanceof SqlNode.ElseDirective ? (SqlNode.ElseDirective)sqlNode : null;
        if (node != null) {
            this.getNodeList().pop();
        }
        return node;
    }

    private final SqlNode.EndDirective getEndDirective() {
        SqlNode node = this.getNodeList().poll();
        if (!(node instanceof SqlNode.EndDirective)) {
            if (node instanceof SqlNode.ElseifDirective) {
                throw new SqlException("The illegal elseif directive is found at " + ((SqlNode.ElseifDirective)node).getLocation());
            }
            if (node instanceof SqlNode.ElseDirective) {
                throw new SqlException("The illegal else directive is found at " + ((SqlNode.ElseDirective)node).getLocation());
            }
            throw new SqlException("The corresponding end directive is not found at " + this.location);
        }
        return (SqlNode.EndDirective)node;
    }
}

