/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.template.sql;

import java.util.Iterator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.komapper.template.sql.AndReducer;
import org.komapper.template.sql.BindValueDirectiveReducer;
import org.komapper.template.sql.BlockReducer;
import org.komapper.template.sql.ElseDirectiveReducer;
import org.komapper.template.sql.ElseifDirectiveReducer;
import org.komapper.template.sql.ForBlockReducer;
import org.komapper.template.sql.ForDirectiveReducer;
import org.komapper.template.sql.ForUpdateReducer;
import org.komapper.template.sql.FromReducer;
import org.komapper.template.sql.GroupByReducer;
import org.komapper.template.sql.HavingReducer;
import org.komapper.template.sql.IfBlockReducer;
import org.komapper.template.sql.IfDirectiveReducer;
import org.komapper.template.sql.LiteralValueDirectiveReducer;
import org.komapper.template.sql.OptionReducer;
import org.komapper.template.sql.OrReducer;
import org.komapper.template.sql.OrderByReducer;
import org.komapper.template.sql.SelectReducer;
import org.komapper.template.sql.SetReducer;
import org.komapper.template.sql.SqlException;
import org.komapper.template.sql.SqlLocation;
import org.komapper.template.sql.SqlNode;
import org.komapper.template.sql.SqlReducer;
import org.komapper.template.sql.SqlTokenType;
import org.komapper.template.sql.SqlTokenizer;
import org.komapper.template.sql.StatementReducer;
import org.komapper.template.sql.WhereReducer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\u0018\u0010!\u001a\u00020\u00162\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0#H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/komapper/template/sql/SqlParser;", "", "sql", "", "tokenizer", "Lorg/komapper/template/sql/SqlTokenizer;", "(Ljava/lang/String;Lorg/komapper/template/sql/SqlTokenizer;)V", "location", "Lorg/komapper/template/sql/SqlLocation;", "getLocation", "()Lorg/komapper/template/sql/SqlLocation;", "reducers", "Ljava/util/LinkedList;", "Lorg/komapper/template/sql/SqlReducer;", "getSql", "()Ljava/lang/String;", "token", "tokenType", "Lorg/komapper/template/sql/SqlTokenType;", "parse", "Lorg/komapper/template/sql/SqlNode;", "parseBindValueDirective", "", "parseElseDirective", "parseElseifDirective", "parseEmbeddedValueDirective", "parseEndDirective", "parseForDirective", "parseIfDirective", "parseLiteralValueDirective", "pushNode", "node", "reduceAll", "reduceUntil", "klass", "Lkotlin/reflect/KClass;", "komapper-template"})
public final class SqlParser {
    @NotNull
    private final String sql;
    @NotNull
    private final SqlTokenizer tokenizer;
    @NotNull
    private final LinkedList<SqlReducer> reducers;
    @NotNull
    private SqlTokenType tokenType;
    @NotNull
    private String token;

    public SqlParser(@NotNull String sql, @NotNull SqlTokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.sql = sql;
        this.tokenizer = tokenizer;
        this.reducers = new LinkedList();
        this.tokenType = SqlTokenType.EOF;
        this.token = "";
        this.reducers.push(new StatementReducer());
    }

    public /* synthetic */ SqlParser(String string, SqlTokenizer sqlTokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            sqlTokenizer = new SqlTokenizer(string);
        }
        this(string, sqlTokenizer);
    }

    @NotNull
    public final String getSql() {
        return this.sql;
    }

    private final SqlLocation getLocation() {
        return this.tokenizer.getLocation();
    }

    @NotNull
    public final SqlNode parse() {
        block28: while (true) {
            this.tokenType = this.tokenizer.next();
            this.token = this.tokenizer.getToken();
            SqlTokenType sqlTokenType = this.tokenType;
            int n = WhenMappings.$EnumSwitchMapping$0[sqlTokenType.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    break block28;
                }
                case 3: {
                    SqlParser parser = new SqlParser(this.sql, this.tokenizer);
                    SqlNode node = parser.parse();
                    if (parser.tokenType != SqlTokenType.CLOSE_PAREN) {
                        throw new SqlException("The close paren is not found at " + this.getLocation());
                    }
                    this.pushNode(new SqlNode.Paren(node));
                    continue block28;
                }
                case 4: {
                    break block28;
                }
                case 5: 
                case 6: {
                    this.pushNode(new SqlNode.Token.Word(this.token));
                    continue block28;
                }
                case 7: {
                    this.pushNode(SqlNode.Token.Space.Companion.of(this.token));
                    continue block28;
                }
                case 8: 
                case 9: {
                    this.pushNode(SqlNode.Token.Other.Companion.of(this.token));
                    continue block28;
                }
                case 10: 
                case 11: {
                    this.pushNode(new SqlNode.Token.Comment(this.token));
                    continue block28;
                }
                case 12: {
                    this.reducers.push(new SelectReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 13: {
                    this.reducers.push(new FromReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 14: {
                    this.reducers.push(new WhereReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 15: {
                    this.reducers.push(new GroupByReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 16: {
                    this.reducers.push(new HavingReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 17: {
                    this.reducers.push(new OrderByReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 18: {
                    this.reducers.push(new ForUpdateReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 19: {
                    this.reducers.push(new OptionReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 20: {
                    this.reducers.push(new AndReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 21: {
                    this.reducers.push(new OrReducer(this.getLocation(), this.token));
                    continue block28;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    SqlNode node = this.reduceAll();
                    this.reducers.push(new SetReducer(this.getLocation(), this.token, node));
                    this.reducers.push(new StatementReducer());
                    continue block28;
                }
                case 26: {
                    this.parseBindValueDirective();
                    continue block28;
                }
                case 27: {
                    this.parseLiteralValueDirective();
                    continue block28;
                }
                case 28: {
                    this.parseEmbeddedValueDirective();
                    continue block28;
                }
                case 29: {
                    this.parseIfDirective();
                    continue block28;
                }
                case 30: {
                    this.parseElseifDirective();
                    continue block28;
                }
                case 31: {
                    this.parseElseDirective();
                    continue block28;
                }
                case 32: {
                    this.parseEndDirective();
                    continue block28;
                }
                case 33: {
                    this.parseForDirective();
                }
                default: {
                    continue block28;
                }
            }
            break;
        }
        return this.reduceAll();
    }

    private final void parseBindValueDirective() {
        CharSequence charSequence = this.token;
        int n = 2;
        int n2 = this.token.length() - 2;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string2;
        n = 0;
        String string3 = charSequence;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expression = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = expression;
        n = 0;
        if (charSequence.length() == 0) {
            throw new SqlException("The expression is not found in the bind value directive at " + this.getLocation());
        }
        this.reducers.push(new BindValueDirectiveReducer(this.getLocation(), this.token, expression));
    }

    private final void parseLiteralValueDirective() {
        CharSequence charSequence = this.token;
        int n = 3;
        int n2 = this.token.length() - 2;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string2;
        n = 0;
        String string3 = charSequence;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expression = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = expression;
        n = 0;
        if (charSequence.length() == 0) {
            throw new SqlException("The expression is not found in the literal value directive at " + this.getLocation());
        }
        this.reducers.push(new LiteralValueDirectiveReducer(this.getLocation(), this.token, expression));
    }

    private final void parseEmbeddedValueDirective() {
        CharSequence charSequence = this.token;
        int n = 3;
        int n2 = this.token.length() - 2;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string2;
        n = 0;
        String string3 = charSequence;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expression = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = expression;
        n = 0;
        if (charSequence.length() == 0) {
            throw new SqlException("The expression is not found in the embedded value directive at " + this.getLocation());
        }
        this.pushNode(new SqlNode.EmbeddedValueDirective(this.getLocation(), this.token, expression));
    }

    private final void parseIfDirective() {
        CharSequence charSequence = this.token;
        int n = 5;
        int n2 = this.token.length() - 2;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string2;
        n = 0;
        String string3 = charSequence;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expression = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = expression;
        n = 0;
        if (charSequence.length() == 0) {
            throw new SqlException("The expression is not found in the if directive at " + this.getLocation());
        }
        this.reducers.push(new IfBlockReducer(this.getLocation()));
        this.reducers.push(new IfDirectiveReducer(this.getLocation(), this.token, expression));
    }

    private final void parseElseifDirective() {
        CharSequence charSequence = this.token;
        int n = 9;
        int n2 = this.token.length() - 2;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string2;
        n = 0;
        String string3 = charSequence;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expression = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = expression;
        n = 0;
        if (charSequence.length() == 0) {
            throw new SqlException("The expression is not found in the elseif directive at " + this.getLocation());
        }
        this.reduceUntil((KClass<? extends SqlReducer>)Reflection.getOrCreateKotlinClass(IfBlockReducer.class));
        if (this.reducers.isEmpty()) {
            throw new SqlException("The corresponding if directive is not found at " + this.getLocation());
        }
        this.reducers.push(new ElseifDirectiveReducer(this.getLocation(), this.token, expression));
    }

    private final void parseElseDirective() {
        this.reduceUntil((KClass<? extends SqlReducer>)Reflection.getOrCreateKotlinClass(IfBlockReducer.class));
        if (this.reducers.isEmpty()) {
            throw new SqlException("The corresponding if directive is not found at " + this.getLocation());
        }
        this.reducers.push(new ElseDirectiveReducer(this.getLocation(), this.token));
    }

    private final void parseEndDirective() {
        this.reduceUntil((KClass<? extends SqlReducer>)Reflection.getOrCreateKotlinClass(BlockReducer.class));
        if (this.reducers.isEmpty()) {
            throw new SqlException("The corresponding if or for directive is not found at " + this.getLocation());
        }
        this.pushNode(new SqlNode.EndDirective(this.getLocation(), this.token));
        SqlReducer block = this.reducers.pop();
        this.pushNode(block.reduce());
    }

    private final void parseForDirective() {
        CharSequence charSequence = this.token;
        int n = 6;
        int n2 = this.token.length() - 2;
        int n3 = 0;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence = string2;
        n = 0;
        String string3 = charSequence;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String statement = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        charSequence = statement;
        n = 0;
        if (charSequence.length() == 0) {
            throw new SqlException("The statement is not found in the for directive at " + this.getLocation());
        }
        int pos = StringsKt.indexOf$default((CharSequence)statement, (String)"in", (int)0, (boolean)false, (int)6, null);
        if (pos == -1) {
            throw new SqlException("The keyword \"in\" is not found in the statement in the for directive at " + this.getLocation());
        }
        CharSequence charSequence2 = statement;
        n3 = 0;
        int n4 = 0;
        String string4 = charSequence2;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n3, pos);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        charSequence2 = string5;
        n3 = 0;
        String string6 = charSequence2;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String identifier = ((Object)StringsKt.trim((CharSequence)string6)).toString();
        charSequence2 = identifier;
        n3 = 0;
        if (charSequence2.length() == 0) {
            throw new SqlException("The identifier is not found in the statement in the for directive at " + this.getLocation());
        }
        CharSequence charSequence3 = statement;
        n4 = pos + 1;
        boolean bl = false;
        String string7 = charSequence3;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n4);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        charSequence3 = string8;
        n4 = 0;
        String string9 = charSequence3;
        if (string9 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expression = ((Object)StringsKt.trim((CharSequence)string9)).toString();
        charSequence3 = expression;
        n4 = 0;
        if (charSequence3.length() == 0) {
            throw new SqlException("The expression is not found in the statement in the for directive at " + this.getLocation());
        }
        this.reducers.push(new ForBlockReducer(this.getLocation()));
        this.reducers.push(new ForDirectiveReducer(this.getLocation(), this.token, identifier, expression));
    }

    private final void reduceUntil(KClass<? extends SqlReducer> klass) {
        Iterator iterator = this.reducers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"reducers.iterator()");
        Iterator it = iterator;
        while (it.hasNext()) {
            Object e = it.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"it.next()");
            SqlReducer reducer = (SqlReducer)e;
            if (KClasses.isSubclassOf((KClass)Reflection.getOrCreateKotlinClass(reducer.getClass()), klass)) break;
            it.remove();
            SqlNode node = reducer.reduce();
            this.pushNode(node);
        }
    }

    private final SqlNode reduceAll() {
        Object object;
        Iterator iterator = this.reducers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"reducers.iterator()");
        Iterator it = iterator;
        SqlNode node = null;
        while (it.hasNext()) {
            object = it.next();
            Intrinsics.checkNotNullExpressionValue(object, (String)"it.next()");
            SqlReducer reducer = (SqlReducer)object;
            it.remove();
            node = reducer.reduce();
            this.pushNode(node);
        }
        SqlNode sqlNode = node;
        if (sqlNode == null) {
            object = "no reducers";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return sqlNode;
    }

    private final void pushNode(SqlNode node) {
        SqlReducer sqlReducer = this.reducers.peek();
        if (sqlReducer != null) {
            sqlReducer.addNode(node);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlTokenType.values().length];
            nArray[SqlTokenType.DELIMITER.ordinal()] = 1;
            nArray[SqlTokenType.EOF.ordinal()] = 2;
            nArray[SqlTokenType.OPEN_PAREN.ordinal()] = 3;
            nArray[SqlTokenType.CLOSE_PAREN.ordinal()] = 4;
            nArray[SqlTokenType.WORD.ordinal()] = 5;
            nArray[SqlTokenType.QUOTE.ordinal()] = 6;
            nArray[SqlTokenType.SPACE.ordinal()] = 7;
            nArray[SqlTokenType.OTHER.ordinal()] = 8;
            nArray[SqlTokenType.EOL.ordinal()] = 9;
            nArray[SqlTokenType.MULTI_LINE_COMMENT.ordinal()] = 10;
            nArray[SqlTokenType.SINGLE_LINE_COMMENT.ordinal()] = 11;
            nArray[SqlTokenType.SELECT.ordinal()] = 12;
            nArray[SqlTokenType.FROM.ordinal()] = 13;
            nArray[SqlTokenType.WHERE.ordinal()] = 14;
            nArray[SqlTokenType.GROUP_BY.ordinal()] = 15;
            nArray[SqlTokenType.HAVING.ordinal()] = 16;
            nArray[SqlTokenType.ORDER_BY.ordinal()] = 17;
            nArray[SqlTokenType.FOR_UPDATE.ordinal()] = 18;
            nArray[SqlTokenType.OPTION.ordinal()] = 19;
            nArray[SqlTokenType.AND.ordinal()] = 20;
            nArray[SqlTokenType.OR.ordinal()] = 21;
            nArray[SqlTokenType.UNION.ordinal()] = 22;
            nArray[SqlTokenType.EXCEPT.ordinal()] = 23;
            nArray[SqlTokenType.MINUS.ordinal()] = 24;
            nArray[SqlTokenType.INTERSECT.ordinal()] = 25;
            nArray[SqlTokenType.BIND_VALUE_DIRECTIVE.ordinal()] = 26;
            nArray[SqlTokenType.LITERAL_VALUE_DIRECTIVE.ordinal()] = 27;
            nArray[SqlTokenType.EMBEDDED_VALUE_DIRECTIVE.ordinal()] = 28;
            nArray[SqlTokenType.IF_DIRECTIVE.ordinal()] = 29;
            nArray[SqlTokenType.ELSEIF_DIRECTIVE.ordinal()] = 30;
            nArray[SqlTokenType.ELSE_DIRECTIVE.ordinal()] = 31;
            nArray[SqlTokenType.END_DIRECTIVE.ordinal()] = 32;
            nArray[SqlTokenType.FOR_DIRECTIVE.ordinal()] = 33;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

