/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.template.sql;

import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.komapper.template.sql.SqlException;
import org.komapper.template.sql.SqlLocation;
import org.komapper.template.sql.SqlTokenType;
import org.komapper.template.sql.SqlTokenizerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u0006\u0010\u001d\u001a\u00020\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/komapper/template/sql/SqlTokenizer;", "", "sql", "", "(Ljava/lang/String;)V", "buf", "Ljava/nio/CharBuffer;", "lineNumber", "", "lineStartPosition", "location", "Lorg/komapper/template/sql/SqlLocation;", "getLocation", "()Lorg/komapper/template/sql/SqlLocation;", "lookahead", "", "<set-?>", "token", "getToken", "()Ljava/lang/String;", "tokenBuf", "type", "Lorg/komapper/template/sql/SqlTokenType;", "isDirectiveTerminated", "", "isWordStart", "c", "", "isWordTerminated", "next", "read", "", "readEightChars", "readFiveChars", "readFourChars", "readNineChars", "readOneChar", "readSevenChars", "readSixChars", "readTenChars", "readThreeChars", "readTwoChars", "Companion", "komapper-template"})
public final class SqlTokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sql;
    @NotNull
    private final char[] lookahead;
    @NotNull
    private final CharBuffer buf;
    @NotNull
    private final CharBuffer tokenBuf;
    private int lineNumber;
    private int lineStartPosition;
    @NotNull
    private SqlTokenType type;
    @NotNull
    private String token;
    public static final int LOOKAHEAD_SIZE = 10;

    public SqlTokenizer(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.sql = sql;
        this.lookahead = new char[10];
        CharBuffer charBuffer = CharBuffer.wrap(this.sql);
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"wrap(sql)");
        this.buf = charBuffer;
        charBuffer = this.buf.asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"buf.asReadOnlyBuffer()");
        this.tokenBuf = charBuffer;
        this.lineNumber = 1;
        this.type = SqlTokenType.EOF;
        this.token = "";
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final SqlLocation getLocation() {
        return new SqlLocation(this.sql, this.lineNumber, this.buf.position() - this.lineStartPosition);
    }

    @NotNull
    public final SqlTokenType next() {
        if (this.type == SqlTokenType.EOL) {
            this.lineStartPosition = this.buf.position();
        }
        this.read();
        this.tokenBuf.limit(this.buf.position());
        String string = this.tokenBuf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokenBuf.toString()");
        this.token = string;
        this.tokenBuf.position(this.buf.position());
        return this.type;
    }

    private final void read() {
        int length = RangesKt.coerceAtMost((int)this.buf.remaining(), (int)10);
        this.buf.get(this.lookahead, 0, length);
        int n = length;
        switch (n) {
            case 10: {
                this.readTenChars(this.lookahead);
                break;
            }
            case 9: {
                this.readNineChars(this.lookahead);
                break;
            }
            case 8: {
                this.readEightChars(this.lookahead);
                break;
            }
            case 7: {
                this.readSevenChars(this.lookahead);
                break;
            }
            case 6: {
                this.readSixChars(this.lookahead);
                break;
            }
            case 5: {
                this.readFiveChars(this.lookahead);
                break;
            }
            case 4: {
                this.readFourChars(this.lookahead);
                break;
            }
            case 3: {
                this.readThreeChars(this.lookahead);
                break;
            }
            case 2: {
                this.readTwoChars(this.lookahead);
                break;
            }
            case 1: {
                this.readOneChar(this.lookahead[0]);
                break;
            }
            case 0: {
                this.type = SqlTokenType.EOF;
                break;
            }
            default: {
                Integer n2 = length;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(((Object)n2).toString());
            }
        }
    }

    private final void readTenChars(char[] c) {
        if (!(c[0] != 'f' && c[0] != 'F' || c[1] != 'o' && c[1] != 'O' || c[2] != 'r' && c[2] != 'R' || !SqlTokenizerKt.access$isSpace(c[3]) || c[4] != 'u' && c[4] != 'U' || c[5] != 'p' && c[5] != 'P' || c[6] != 'd' && c[6] != 'D' || c[7] != 'a' && c[7] != 'A' || c[8] != 't' && c[8] != 'T' || c[9] != 'e' && c[9] != 'E')) {
            this.type = SqlTokenType.FOR_UPDATE;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.readNineChars(c);
    }

    private final void readNineChars(char[] c) {
        if (!(c[0] != 'i' && c[0] != 'I' || c[1] != 'n' && c[1] != 'N' || c[2] != 't' && c[2] != 'T' || c[3] != 'e' && c[3] != 'E' || c[4] != 'r' && c[4] != 'R' || c[5] != 's' && c[5] != 'S' || c[6] != 'e' && c[6] != 'E' || c[7] != 'c' && c[7] != 'C' || c[8] != 't' && c[8] != 'T')) {
            this.type = SqlTokenType.INTERSECT;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.readEightChars(c);
    }

    private final void readEightChars(char[] c) {
        if (!(c[0] != 'g' && c[0] != 'G' || c[1] != 'r' && c[1] != 'R' || c[2] != 'o' && c[2] != 'O' || c[3] != 'u' && c[3] != 'U' || c[4] != 'p' && c[4] != 'P' || !SqlTokenizerKt.access$isSpace(c[5]) || c[6] != 'b' && c[6] != 'B' || c[7] != 'y' && c[7] != 'Y')) {
            this.type = SqlTokenType.GROUP_BY;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c[0] != 'o' && c[0] != 'O' || c[1] != 'r' && c[1] != 'R' || c[2] != 'd' && c[2] != 'D' || c[3] != 'e' && c[3] != 'E' || c[4] != 'r' && c[4] != 'R' || !SqlTokenizerKt.access$isSpace(c[5]) || c[6] != 'b' && c[6] != 'B' || c[7] != 'y' && c[7] != 'Y')) {
            this.type = SqlTokenType.ORDER_BY;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c[0] != 'o' && c[0] != 'O' || c[1] != 'p' && c[1] != 'P' || c[2] != 't' && c[2] != 'T' || c[3] != 'i' && c[3] != 'I' || c[4] != 'o' && c[4] != 'O' || c[5] != 'n' && c[5] != 'N' || !SqlTokenizerKt.access$isSpace(c[6]) || c[7] != '(')) {
            this.type = SqlTokenType.OPTION;
            this.buf.position(this.buf.position() - 2);
            return;
        }
        this.buf.position(this.buf.position() - 1);
        this.readSevenChars(c);
    }

    private final void readSevenChars(char[] c) {
        this.buf.position(this.buf.position() - 1);
        this.readSixChars(c);
    }

    private final void readSixChars(char[] c) {
        if (!(c[0] != 's' && c[0] != 'S' || c[1] != 'e' && c[1] != 'E' || c[2] != 'l' && c[2] != 'L' || c[3] != 'e' && c[3] != 'E' || c[4] != 'c' && c[4] != 'C' || c[5] != 't' && c[5] != 'T')) {
            this.type = SqlTokenType.SELECT;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c[0] != 'h' && c[0] != 'H' || c[1] != 'a' && c[1] != 'A' || c[2] != 'v' && c[2] != 'V' || c[3] != 'i' && c[3] != 'I' || c[4] != 'n' && c[4] != 'N' || c[5] != 'g' && c[5] != 'G')) {
            this.type = SqlTokenType.HAVING;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c[0] != 'e' && c[0] != 'E' || c[1] != 'x' && c[1] != 'X' || c[2] != 'c' && c[2] != 'C' || c[3] != 'e' && c[3] != 'E' || c[4] != 'p' && c[4] != 'P' || c[5] != 't' && c[5] != 'T')) {
            this.type = SqlTokenType.EXCEPT;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.readFiveChars(c);
    }

    private final void readFiveChars(char[] c) {
        if (!(c[0] != 'w' && c[0] != 'W' || c[1] != 'h' && c[1] != 'H' || c[2] != 'e' && c[2] != 'E' || c[3] != 'r' && c[3] != 'R' || c[4] != 'e' && c[4] != 'E')) {
            this.type = SqlTokenType.WHERE;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c[0] != 'u' && c[0] != 'U' || c[1] != 'n' && c[1] != 'N' || c[2] != 'i' && c[2] != 'I' || c[3] != 'o' && c[3] != 'O' || c[4] != 'n' && c[4] != 'N')) {
            this.type = SqlTokenType.UNION;
            if (this.isWordTerminated()) {
                return;
            }
        } else if (!(c[0] != 'm' && c[0] != 'M' || c[1] != 'i' && c[1] != 'I' || c[2] != 'n' && c[2] != 'N' || c[3] != 'u' && c[3] != 'U' || c[4] != 's' && c[4] != 'S')) {
            this.type = SqlTokenType.MINUS;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.readFourChars(c);
    }

    private final void readFourChars(char[] c) {
        if (!(c[0] != 'f' && c[0] != 'F' || c[1] != 'r' && c[1] != 'R' || c[2] != 'o' && c[2] != 'O' || c[3] != 'm' && c[3] != 'M')) {
            this.type = SqlTokenType.FROM;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.readThreeChars(c);
    }

    private final void readThreeChars(char[] c) {
        if (!(c[0] != 'a' && c[0] != 'A' || c[1] != 'n' && c[1] != 'N' || c[2] != 'd' && c[2] != 'D')) {
            this.type = SqlTokenType.AND;
            if (this.isWordTerminated()) {
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.readTwoChars(c);
    }

    private final void readTwoChars(char[] c) {
        if (!(c[0] != 'o' && c[0] != 'O' || c[1] != 'r' && c[1] != 'R')) {
            this.type = SqlTokenType.OR;
            if (this.isWordTerminated()) {
                return;
            }
        } else {
            if (c[0] == '/' && c[1] == '*') {
                char c3;
                char c2;
                this.type = SqlTokenType.MULTI_LINE_COMMENT;
                if (this.buf.hasRemaining()) {
                    c2 = this.buf.get();
                    if (SqlTokenizerKt.access$isExpressionIdentifierStart(c2)) {
                        this.type = SqlTokenType.BIND_VALUE_DIRECTIVE;
                    } else if (c2 == '^') {
                        this.type = SqlTokenType.LITERAL_VALUE_DIRECTIVE;
                    } else if (c2 == '#') {
                        this.type = SqlTokenType.EMBEDDED_VALUE_DIRECTIVE;
                    } else if (c2 == '%') {
                        if (this.buf.hasRemaining()) {
                            c3 = this.buf.get();
                            if (this.buf.hasRemaining()) {
                                char c4 = this.buf.get();
                                if (c3 == 'i' && c4 == 'f') {
                                    if (this.isDirectiveTerminated()) {
                                        this.type = SqlTokenType.IF_DIRECTIVE;
                                    }
                                } else if (this.buf.hasRemaining()) {
                                    char c5 = this.buf.get();
                                    if (c3 == 'f' && c4 == 'o' && c5 == 'r') {
                                        if (this.isDirectiveTerminated()) {
                                            this.type = SqlTokenType.FOR_DIRECTIVE;
                                        }
                                    } else if (c3 == 'e' && c4 == 'n' && c5 == 'd') {
                                        if (this.isDirectiveTerminated()) {
                                            this.type = SqlTokenType.END_DIRECTIVE;
                                        }
                                    } else if (this.buf.hasRemaining()) {
                                        char c6 = this.buf.get();
                                        if (c3 == 'e' && c4 == 'l' && c5 == 's' && c6 == 'e') {
                                            if (this.isDirectiveTerminated()) {
                                                this.type = SqlTokenType.ELSE_DIRECTIVE;
                                            } else if (this.buf.hasRemaining()) {
                                                char c7 = this.buf.get();
                                                if (this.buf.hasRemaining()) {
                                                    char c8 = this.buf.get();
                                                    if (c7 == 'i' && c8 == 'f') {
                                                        if (this.isDirectiveTerminated()) {
                                                            this.type = SqlTokenType.ELSEIF_DIRECTIVE;
                                                        }
                                                    } else {
                                                        this.buf.position(this.buf.position() - 6);
                                                    }
                                                } else {
                                                    this.buf.position(this.buf.position() - 5);
                                                }
                                            }
                                        } else {
                                            this.buf.position(this.buf.position() - 4);
                                        }
                                    } else {
                                        this.buf.position(this.buf.position() - 3);
                                    }
                                } else {
                                    this.buf.position(this.buf.position() - 2);
                                }
                            } else {
                                this.buf.position(this.buf.position() - 1);
                            }
                        }
                        if (this.type != SqlTokenType.IF_DIRECTIVE && this.type != SqlTokenType.FOR_DIRECTIVE && this.type != SqlTokenType.END_DIRECTIVE && this.type != SqlTokenType.ELSE_DIRECTIVE && this.type != SqlTokenType.ELSEIF_DIRECTIVE) {
                            throw new SqlException("Unsupported directive name is found at " + this.getLocation());
                        }
                    }
                    this.buf.position(this.buf.position() - 1);
                }
                while (this.buf.hasRemaining()) {
                    c2 = this.buf.get();
                    if (!this.buf.hasRemaining()) continue;
                    this.buf.mark();
                    c3 = this.buf.get();
                    if (c2 == '*' && c3 == '/') {
                        return;
                    }
                    if (c2 == '\r' && c3 == '\n' || c2 == '\r' || c2 == '\n') {
                        SqlTokenizer sqlTokenizer = this;
                        int n = sqlTokenizer.lineNumber;
                        sqlTokenizer.lineNumber = n + 1;
                    }
                    this.buf.reset();
                }
                throw new SqlException("The token \"*/\" for the end of the multi-line comment is not found at " + this.getLocation());
            }
            if (c[0] == '-' && c[1] == '-') {
                this.type = SqlTokenType.SINGLE_LINE_COMMENT;
                while (this.buf.hasRemaining()) {
                    this.buf.mark();
                    char c2 = this.buf.get();
                    if (c2 != '\r' && c2 != '\n') continue;
                    this.buf.reset();
                    return;
                }
                return;
            }
            if (c[0] == '\r' && c[1] == '\n') {
                this.type = SqlTokenType.EOL;
                SqlTokenizer sqlTokenizer = this;
                int n = sqlTokenizer.lineNumber;
                sqlTokenizer.lineNumber = n + 1;
                return;
            }
        }
        this.buf.position(this.buf.position() - 1);
        this.readOneChar(c[0]);
    }

    private final void readOneChar(char c) {
        if (SqlTokenizerKt.access$isSpace(c)) {
            this.type = SqlTokenType.SPACE;
        } else if (c == '(') {
            this.type = SqlTokenType.OPEN_PAREN;
        } else if (c == ')') {
            this.type = SqlTokenType.CLOSE_PAREN;
        } else if (c == ';') {
            this.type = SqlTokenType.DELIMITER;
        } else {
            if (c == '\'') {
                this.type = SqlTokenType.QUOTE;
                boolean closed = false;
                while (this.buf.hasRemaining()) {
                    char c1 = this.buf.get();
                    if (c1 != '\'') continue;
                    if (this.buf.hasRemaining()) {
                        this.buf.mark();
                        char c2 = this.buf.get();
                        if (c2 == '\'') continue;
                        this.buf.reset();
                        closed = true;
                        break;
                    }
                    closed = true;
                }
                if (closed) {
                    return;
                }
                throw new SqlException("The token \"'\" for the end of the string literal is not found at " + this.getLocation());
            }
            if (this.isWordStart(c)) {
                this.type = SqlTokenType.WORD;
                while (this.buf.hasRemaining()) {
                    this.buf.mark();
                    char c1 = this.buf.get();
                    if (c1 == '\'') {
                        boolean closed = false;
                        while (this.buf.hasRemaining()) {
                            char c2 = this.buf.get();
                            if (c2 != '\'') continue;
                            if (this.buf.hasRemaining()) {
                                this.buf.mark();
                                char c3 = this.buf.get();
                                if (c3 == '\'') continue;
                                this.buf.reset();
                                closed = true;
                                break;
                            }
                            closed = true;
                        }
                        if (closed) {
                            return;
                        }
                        throw new SqlException("The token \"'\" for the end of the string literal is not found at " + this.getLocation());
                    }
                    if (SqlTokenizerKt.access$isWordPart(c1)) continue;
                    this.buf.reset();
                    return;
                }
            } else if (c == '\r' || c == '\n') {
                this.type = SqlTokenType.EOL;
                SqlTokenizer sqlTokenizer = this;
                int n = sqlTokenizer.lineNumber;
                sqlTokenizer.lineNumber = n + 1;
            } else {
                this.type = SqlTokenType.OTHER;
            }
        }
    }

    private final boolean isWordStart(char c) {
        if (c == '+' || c == '-') {
            this.buf.mark();
            if (this.buf.hasRemaining()) {
                char c1 = this.buf.get();
                this.buf.reset();
                char c2 = c1;
                boolean bl = false;
                if (Character.isDigit(c2)) {
                    return true;
                }
            }
        }
        return SqlTokenizerKt.access$isWordPart(c);
    }

    private final boolean isWordTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            this.buf.reset();
            return !SqlTokenizerKt.access$isWordPart(c);
        }
        return true;
    }

    private final boolean isDirectiveTerminated() {
        this.buf.mark();
        if (this.buf.hasRemaining()) {
            char c = this.buf.get();
            this.buf.reset();
            return !SqlTokenizerKt.access$isWordPart(c);
        }
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/komapper/template/sql/SqlTokenizer$Companion;", "", "()V", "LOOKAHEAD_SIZE", "", "komapper-template"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

