/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JsonObjectAsMap {
    public Map<String, Object> createMapFromJsonObject(JsonObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            map.put((String)entry.getKey(), this.createObjectFromJsonElement((JsonElement)entry.getValue()));
        }
        return map;
    }

    public Object createObjectFromJsonElement(JsonElement value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
        }
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            ArrayList<Object> values = new ArrayList<Object>();
            for (JsonElement element : array) {
                values.add(this.createObjectFromJsonElement(element));
            }
            return values;
        }
        if (value instanceof JsonObject) {
            return this.createObjectFromJsonElement(value);
        }
        throw new RuntimeException("Unrecognized json element: " + value);
    }
}

