/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.definition;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.kurento.modulecreator.definition.ModelElement;
import org.kurento.modulecreator.definition.Property;
import org.kurento.modulecreator.definition.Type;
import org.kurento.modulecreator.definition.TypeRef;

public class ComplexType
extends Type {
    private TypeFormat typeFormat;
    @SerializedName(value="extends")
    private TypeRef extendsProp;
    private List<Property> properties = new ArrayList<Property>();
    private List<Property> parentProperties;
    private List<String> values;

    public ComplexType(String name, String doc, List<Property> properties, List<String> values) {
        super(name, doc);
        this.properties = properties;
        this.values = values;
        if (properties != null) {
            this.typeFormat = TypeFormat.REGISTER;
        } else if (values != null) {
            this.typeFormat = TypeFormat.ENUM;
        } else {
            new AssertionError((Object)"Properties or values have to have a non null value");
        }
    }

    public TypeRef getExtends() {
        return this.extendsProp;
    }

    public void setExtends(TypeRef extendsProp) {
        this.extendsProp = extendsProp;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public TypeFormat getTypeFormat() {
        return this.typeFormat;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getParentProperties() {
        if (this.parentProperties == null) {
            this.resolveParentProperties();
        }
        return this.parentProperties;
    }

    public void setParentProperties(List<Property> parentProperties) {
        this.parentProperties = parentProperties;
    }

    private void resolveParentProperties() {
        this.parentProperties = new ArrayList<Property>();
        if (this.extendsProp != null) {
            ComplexType complexType = (ComplexType)this.extendsProp.getType();
            this.parentProperties.addAll(complexType.getParentProperties());
            this.parentProperties.addAll(complexType.getProperties());
        }
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    @Override
    public List<ModelElement> getChildren() {
        ArrayList<ModelElement> children = new ArrayList<ModelElement>();
        if (this.extendsProp != null) {
            children.add(this.extendsProp);
        }
        if (this.properties != null) {
            children.addAll(this.properties);
        }
        return children;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extendsProp == null ? 0 : this.extendsProp.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.typeFormat == null ? 0 : this.typeFormat.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexType other = (ComplexType)obj;
        if (this.extendsProp == null ? other.extendsProp != null : !this.extendsProp.equals(other.extendsProp)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.typeFormat != other.typeFormat) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public static enum TypeFormat {
        REGISTER,
        ENUM;

    }
}

