/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.definition;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.kurento.modulecreator.definition.ModelElement;
import org.kurento.modulecreator.definition.Property;
import org.kurento.modulecreator.definition.Type;
import org.kurento.modulecreator.definition.TypeRef;

public class Event
extends Type {
    private List<Property> properties;
    @SerializedName(value="extends")
    private TypeRef extendsProp;
    private List<Property> parentProperties;

    public Event(String name, String doc, List<Property> properties) {
        super(name, doc);
        this.properties = properties;
    }

    public void setExtends(TypeRef extendsProp) {
        this.extendsProp = extendsProp;
    }

    public TypeRef getExtends() {
        return this.extendsProp;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getParentProperties() {
        if (this.parentProperties == null) {
            this.resolveParentProperties();
        }
        return this.parentProperties;
    }

    public void setParentProperties(List<Property> parentProperties) {
        this.parentProperties = parentProperties;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extendsProp == null ? 0 : this.extendsProp.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.extendsProp == null ? other.extendsProp != null : !this.extendsProp.equals(other.extendsProp)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "Event [properties=" + this.properties + ", extendsProp=" + this.extendsProp + ", getDoc()=" + this.getDoc() + ", getName()=" + this.getName() + "]";
    }

    @Override
    public List<ModelElement> getChildren() {
        ArrayList<ModelElement> elements = new ArrayList<ModelElement>(this.properties);
        if (this.extendsProp != null) {
            elements.add(this.extendsProp);
        }
        return elements;
    }

    private void resolveParentProperties() {
        this.parentProperties = new ArrayList<Property>();
        if (this.extendsProp != null) {
            Event event = (Event)this.extendsProp.getType();
            this.parentProperties.addAll(event.getParentProperties());
            this.parentProperties.addAll(event.getProperties());
        }
    }
}

