/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.tutorial.groupcall;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.kurento.client.IceCandidate;
import org.kurento.tutorial.groupcall.Room;
import org.kurento.tutorial.groupcall.RoomManager;
import org.kurento.tutorial.groupcall.UserRegistry;
import org.kurento.tutorial.groupcall.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class CallHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(CallHandler.class);
    private static final Gson gson = new GsonBuilder().create();
    @Autowired
    private RoomManager roomManager;
    @Autowired
    private UserRegistry registry;

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        JsonObject jsonMessage = (JsonObject)gson.fromJson((String)message.getPayload(), JsonObject.class);
        UserSession user = this.registry.getBySession(session);
        if (user != null) {
            log.debug("Incoming message from user '{}': {}", (Object)user.getName(), (Object)jsonMessage);
        } else {
            log.debug("Incoming message from new user: {}", (Object)jsonMessage);
        }
        switch (jsonMessage.get("id").getAsString()) {
            case "joinRoom": {
                this.joinRoom(jsonMessage, session);
                break;
            }
            case "receiveVideoFrom": {
                String senderName = jsonMessage.get("sender").getAsString();
                UserSession sender = this.registry.getByName(senderName);
                String sdpOffer = jsonMessage.get("sdpOffer").getAsString();
                user.receiveVideoFrom(sender, sdpOffer);
                break;
            }
            case "leaveRoom": {
                this.leaveRoom(user);
                break;
            }
            case "onIceCandidate": {
                JsonObject candidate = jsonMessage.get("candidate").getAsJsonObject();
                if (user == null) break;
                IceCandidate cand = new IceCandidate(candidate.get("candidate").getAsString(), candidate.get("sdpMid").getAsString(), candidate.get("sdpMLineIndex").getAsInt());
                user.addCandidate(cand, jsonMessage.get("name").getAsString());
                break;
            }
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        UserSession user = this.registry.removeBySession(session);
        this.roomManager.getRoom(user.getRoomName()).leave(user);
    }

    private void joinRoom(JsonObject params, WebSocketSession session) throws IOException {
        String roomName = params.get("room").getAsString();
        String name = params.get("name").getAsString();
        log.info("PARTICIPANT {}: trying to join room {}", (Object)name, (Object)roomName);
        Room room = this.roomManager.getRoom(roomName);
        UserSession user = room.join(name, session);
        this.registry.register(user);
    }

    private void leaveRoom(UserSession user) throws IOException {
        Room room = this.roomManager.getRoom(user.getRoomName());
        room.leave(user);
        if (room.getParticipants().isEmpty()) {
            this.roomManager.removeRoom(room);
        }
    }
}

