/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.tutorial.groupcall;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import org.kurento.client.Continuation;
import org.kurento.client.MediaPipeline;
import org.kurento.tutorial.groupcall.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class Room
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(Room.class);
    private final ConcurrentMap<String, UserSession> participants = new ConcurrentHashMap<String, UserSession>();
    private final MediaPipeline pipeline;
    private final String name;

    public String getName() {
        return this.name;
    }

    public Room(String roomName, MediaPipeline pipeline) {
        this.name = roomName;
        this.pipeline = pipeline;
        this.log.info("ROOM {} has been created", (Object)roomName);
    }

    @PreDestroy
    private void shutdown() {
        this.close();
    }

    public UserSession join(String userName, WebSocketSession session) throws IOException {
        this.log.info("ROOM {}: adding participant {}", (Object)userName, (Object)userName);
        UserSession participant = new UserSession(userName, this.name, session, this.pipeline);
        this.joinRoom(participant);
        this.participants.put(participant.getName(), participant);
        this.sendParticipantNames(participant);
        return participant;
    }

    public void leave(UserSession user) throws IOException {
        this.log.debug("PARTICIPANT {}: Leaving room {}", (Object)user.getName(), (Object)this.name);
        this.removeParticipant(user.getName());
        user.close();
    }

    private Collection<String> joinRoom(UserSession newParticipant) throws IOException {
        JsonObject newParticipantMsg = new JsonObject();
        newParticipantMsg.addProperty("id", "newParticipantArrived");
        newParticipantMsg.addProperty("name", newParticipant.getName());
        ArrayList<String> participantsList = new ArrayList<String>(this.participants.values().size());
        this.log.debug("ROOM {}: notifying other participants of new participant {}", (Object)this.name, (Object)newParticipant.getName());
        for (UserSession participant : this.participants.values()) {
            try {
                participant.sendMessage(newParticipantMsg);
            }
            catch (IOException e) {
                this.log.debug("ROOM {}: participant {} could not be notified", new Object[]{this.name, participant.getName(), e});
            }
            participantsList.add(participant.getName());
        }
        return participantsList;
    }

    private void removeParticipant(String name) throws IOException {
        this.participants.remove(name);
        this.log.debug("ROOM {}: notifying all users that {} is leaving the room", (Object)this.name, (Object)name);
        ArrayList<String> unnotifiedParticipants = new ArrayList<String>();
        JsonObject participantLeftJson = new JsonObject();
        participantLeftJson.addProperty("id", "participantLeft");
        participantLeftJson.addProperty("name", name);
        for (UserSession participant : this.participants.values()) {
            try {
                participant.cancelVideoFrom(name);
                participant.sendMessage(participantLeftJson);
            }
            catch (IOException e) {
                unnotifiedParticipants.add(participant.getName());
            }
        }
        if (!unnotifiedParticipants.isEmpty()) {
            this.log.debug("ROOM {}: The users {} could not be notified that {} left the room", new Object[]{this.name, unnotifiedParticipants, name});
        }
    }

    public void sendParticipantNames(UserSession user) throws IOException {
        JsonArray participantsArray = new JsonArray();
        for (UserSession participant : this.getParticipants()) {
            if (participant.equals(user)) continue;
            JsonPrimitive participantName = new JsonPrimitive(participant.getName());
            participantsArray.add((JsonElement)participantName);
        }
        JsonObject existingParticipantsMsg = new JsonObject();
        existingParticipantsMsg.addProperty("id", "existingParticipants");
        existingParticipantsMsg.add("data", (JsonElement)participantsArray);
        this.log.debug("PARTICIPANT {}: sending a list of {} participants", (Object)user.getName(), (Object)participantsArray.size());
        user.sendMessage(existingParticipantsMsg);
    }

    public Collection<UserSession> getParticipants() {
        return this.participants.values();
    }

    public UserSession getParticipant(String name) {
        return (UserSession)this.participants.get(name);
    }

    @Override
    public void close() {
        for (UserSession user : this.participants.values()) {
            try {
                user.close();
            }
            catch (IOException e) {
                this.log.debug("ROOM {}: Could not invoke close on participant {}", new Object[]{this.name, user.getName(), e});
            }
        }
        this.participants.clear();
        this.pipeline.release((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                Room.this.log.trace("ROOM {}: Released Pipeline", (Object)Room.this.name);
            }

            public void onError(Throwable cause) throws Exception {
                Room.this.log.warn("PARTICIPANT {}: Could not release Pipeline", (Object)Room.this.name);
            }
        });
        this.log.debug("Room {} closed", (Object)this.name);
    }
}

