/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.tutorial.groupcall;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.client.KurentoClient;
import org.kurento.tutorial.groupcall.Room;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RoomManager {
    private final Logger log = LoggerFactory.getLogger(RoomManager.class);
    @Autowired
    private KurentoClient kurento;
    private final ConcurrentMap<String, Room> rooms = new ConcurrentHashMap<String, Room>();

    public Room getRoom(String roomName) {
        this.log.debug("Searching for room {}", (Object)roomName);
        Room room = (Room)this.rooms.get(roomName);
        if (room == null) {
            this.log.debug("Room {} not existent. Will create now!", (Object)roomName);
            room = new Room(roomName, this.kurento.createMediaPipeline());
            this.rooms.put(roomName, room);
        }
        this.log.debug("Room {} found!", (Object)roomName);
        return room;
    }

    public void removeRoom(Room room) {
        this.rooms.remove(room.getName());
        room.close();
        this.log.info("Room {} removed and closed", (Object)room.getName());
    }
}

