/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.tutorial.groupcall;

import java.util.concurrent.ConcurrentHashMap;
import org.kurento.tutorial.groupcall.UserSession;
import org.springframework.web.socket.WebSocketSession;

public class UserRegistry {
    private final ConcurrentHashMap<String, UserSession> usersByName = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, UserSession> usersBySessionId = new ConcurrentHashMap();

    public void register(UserSession user) {
        this.usersByName.put(user.getName(), user);
        this.usersBySessionId.put(user.getSession().getId(), user);
    }

    public UserSession getByName(String name) {
        return this.usersByName.get(name);
    }

    public UserSession getBySession(WebSocketSession session) {
        return this.usersBySessionId.get(session.getId());
    }

    public boolean exists(String name) {
        return ((ConcurrentHashMap.KeySetView)this.usersByName.keySet()).contains(name);
    }

    public UserSession removeBySession(WebSocketSession session) {
        UserSession user = this.getBySession(session);
        this.usersByName.remove(user.getName());
        this.usersBySessionId.remove(session.getId());
        return user;
    }
}

