/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.tutorial.groupcall;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kurento.client.Continuation;
import org.kurento.client.EventListener;
import org.kurento.client.IceCandidate;
import org.kurento.client.IceCandidateFoundEvent;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.jsonrpc.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class UserSession
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(UserSession.class);
    private final String name;
    private final WebSocketSession session;
    private final MediaPipeline pipeline;
    private final String roomName;
    private final WebRtcEndpoint outgoingMedia;
    private final ConcurrentMap<String, WebRtcEndpoint> incomingMedia = new ConcurrentHashMap<String, WebRtcEndpoint>();

    public UserSession(final String name, String roomName, final WebSocketSession session, MediaPipeline pipeline) {
        this.pipeline = pipeline;
        this.name = name;
        this.session = session;
        this.roomName = roomName;
        this.outgoingMedia = (WebRtcEndpoint)new WebRtcEndpoint.Builder(pipeline).build();
        this.outgoingMedia.addIceCandidateFoundListener((EventListener)new EventListener<IceCandidateFoundEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(IceCandidateFoundEvent event) {
                JsonObject response = new JsonObject();
                response.addProperty("id", "iceCandidate");
                response.addProperty("name", name);
                response.add("candidate", (JsonElement)JsonUtils.toJsonObject((Object)event.getCandidate()));
                try {
                    WebSocketSession webSocketSession = session;
                    synchronized (webSocketSession) {
                        session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)response.toString()));
                    }
                }
                catch (IOException e) {
                    log.debug(e.getMessage());
                }
            }
        });
    }

    public WebRtcEndpoint getOutgoingWebRtcPeer() {
        return this.outgoingMedia;
    }

    public String getName() {
        return this.name;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public void receiveVideoFrom(UserSession sender, String sdpOffer) throws IOException {
        log.info("USER {}: connecting with {} in room {}", new Object[]{this.name, sender.getName(), this.roomName});
        log.trace("USER {}: SdpOffer for {} is {}", new Object[]{this.name, sender.getName(), sdpOffer});
        String ipSdpAnswer = this.getEndpointForUser(sender).processOffer(sdpOffer);
        JsonObject scParams = new JsonObject();
        scParams.addProperty("id", "receiveVideoAnswer");
        scParams.addProperty("name", sender.getName());
        scParams.addProperty("sdpAnswer", ipSdpAnswer);
        log.trace("USER {}: SdpAnswer for {} is {}", new Object[]{this.name, sender.getName(), ipSdpAnswer});
        this.sendMessage(scParams);
        log.debug("gather candidates");
        this.getEndpointForUser(sender).gatherCandidates();
    }

    private WebRtcEndpoint getEndpointForUser(final UserSession sender) {
        if (sender.getName().equals(this.name)) {
            log.debug("PARTICIPANT {}: configuring loopback", (Object)this.name);
            return this.outgoingMedia;
        }
        log.debug("PARTICIPANT {}: receiving video from {}", (Object)this.name, (Object)sender.getName());
        WebRtcEndpoint incoming = (WebRtcEndpoint)this.incomingMedia.get(sender.getName());
        if (incoming == null) {
            log.debug("PARTICIPANT {}: creating new endpoint for {}", (Object)this.name, (Object)sender.getName());
            incoming = (WebRtcEndpoint)new WebRtcEndpoint.Builder(this.pipeline).build();
            incoming.addIceCandidateFoundListener((EventListener)new EventListener<IceCandidateFoundEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(IceCandidateFoundEvent event) {
                    JsonObject response = new JsonObject();
                    response.addProperty("id", "iceCandidate");
                    response.addProperty("name", sender.getName());
                    response.add("candidate", (JsonElement)JsonUtils.toJsonObject((Object)event.getCandidate()));
                    try {
                        WebSocketSession webSocketSession = UserSession.this.session;
                        synchronized (webSocketSession) {
                            UserSession.this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)response.toString()));
                        }
                    }
                    catch (IOException e) {
                        log.debug(e.getMessage());
                    }
                }
            });
            this.incomingMedia.put(sender.getName(), incoming);
        }
        log.debug("PARTICIPANT {}: obtained endpoint for {}", (Object)this.name, (Object)sender.getName());
        sender.getOutgoingWebRtcPeer().connect((MediaElement)incoming);
        return incoming;
    }

    public void cancelVideoFrom(UserSession sender) {
        this.cancelVideoFrom(sender.getName());
    }

    public void cancelVideoFrom(final String senderName) {
        log.debug("PARTICIPANT {}: canceling video reception from {}", (Object)this.name, (Object)senderName);
        WebRtcEndpoint incoming = (WebRtcEndpoint)this.incomingMedia.remove(senderName);
        log.debug("PARTICIPANT {}: removing endpoint for {}", (Object)this.name, (Object)senderName);
        incoming.release((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("PARTICIPANT {}: Released successfully incoming EP for {}", (Object)UserSession.this.name, (Object)senderName);
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("PARTICIPANT {}: Could not release incoming EP for {}", (Object)UserSession.this.name, (Object)senderName);
            }
        });
    }

    @Override
    public void close() throws IOException {
        log.debug("PARTICIPANT {}: Releasing resources", (Object)this.name);
        for (final String remoteParticipantName : this.incomingMedia.keySet()) {
            log.trace("PARTICIPANT {}: Released incoming EP for {}", (Object)this.name, (Object)remoteParticipantName);
            WebRtcEndpoint ep = (WebRtcEndpoint)this.incomingMedia.get(remoteParticipantName);
            ep.release((Continuation)new Continuation<Void>(){

                public void onSuccess(Void result) throws Exception {
                    log.trace("PARTICIPANT {}: Released successfully incoming EP for {}", (Object)UserSession.this.name, (Object)remoteParticipantName);
                }

                public void onError(Throwable cause) throws Exception {
                    log.warn("PARTICIPANT {}: Could not release incoming EP for {}", (Object)UserSession.this.name, (Object)remoteParticipantName);
                }
            });
        }
        this.outgoingMedia.release((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.trace("PARTICIPANT {}: Released outgoing EP", (Object)UserSession.this.name);
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("USER {}: Could not release outgoing EP", (Object)UserSession.this.name);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(JsonObject message) throws IOException {
        log.debug("USER {}: Sending message {}", (Object)this.name, (Object)message);
        WebSocketSession webSocketSession = this.session;
        synchronized (webSocketSession) {
            this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message.toString()));
        }
    }

    public void addCandidate(IceCandidate candidate, String name) {
        if (this.name.compareTo(name) == 0) {
            this.outgoingMedia.addIceCandidate(candidate);
        } else {
            WebRtcEndpoint webRtc = (WebRtcEndpoint)this.incomingMedia.get(name);
            if (webRtc != null) {
                webRtc.addIceCandidate(candidate);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof UserSession)) {
            return false;
        }
        UserSession other = (UserSession)obj;
        boolean eq = this.name.equals(other.name);
        return eq &= this.roomName.equals(other.roomName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.roomName.hashCode();
        return result;
    }
}

