#!/bin/sh

# kurento-group-call installer for Ubuntu 14.04
if [ `id -u` -ne 0 ]; then
    echo ""
    echo "Only root can start kurento-group-call"
    echo ""
    exit 1
fi

APP_HOME=$(dirname $(dirname $(readlink -f $0)))
CONFIG_FILE="$APP_HOME/config/configuration.conf.json"

# Create defaults
mkdir -p /etc/default
cat > /etc/default/kurento-group-call <<-EOF
# Defaults for kurento-group-call initscript
# sourced by /etc/init.d/kurento-group-call
# installed at /etc/default/kurento-group-call by the maintainer scripts

#
# This is a POSIX shell fragment
#

# Commment next line to disable kurento-group-call daemon
START_DAEMON=true

# Whom the daemons should run as
DAEMON_USER=nobody
EOF

# Install binaries
install -o root -g root -m 755 $APP_HOME/bin/start.sh /usr/bin/kurento-group-call
install -o root -g root -m 755 $APP_HOME/support-files/kurento-demo.sh /etc/init.d/kurento-group-call
mkdir -p /var/lib/kurento
install -o root -g root $APP_HOME/lib/kurento-group-call.jar /var/lib/kurento/
[ -f $CONFIG_FILE ] && ( mkdir -p /etc/kurento/ && install -o root -g root $CONFIG_FILE /etc/kurento/kurento-group-call.conf.json )

# enable kurento-group-call start at boot time
# update-rc.d kurento-group-call defaults

# start kurento-group-call
/etc/init.d/kurento-group-call restart
