/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.maven.surefire.shade.common.org.apache.commons.io.output.DeferredFileOutputStream;

class Utf8RecodingDeferredFileOutputStream {
    private DeferredFileOutputStream deferredFileOutputStream;
    private boolean closed = false;

    Utf8RecodingDeferredFileOutputStream(String channel) {
        this.deferredFileOutputStream = new DeferredFileOutputStream(1000000, channel, "deferred", null);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        if (!Charset.defaultCharset().equals(StandardCharsets.UTF_8)) {
            CharBuffer decodedFromDefaultCharset = Charset.defaultCharset().decode(ByteBuffer.wrap(buf, off, len));
            ByteBuffer utf8Encoded = StandardCharsets.UTF_8.encode(decodedFromDefaultCharset);
            if (utf8Encoded.hasArray()) {
                byte[] convertedBytes = utf8Encoded.array();
                this.deferredFileOutputStream.write(convertedBytes, utf8Encoded.position(), utf8Encoded.remaining());
            } else {
                byte[] convertedBytes = new byte[utf8Encoded.remaining()];
                utf8Encoded.get(convertedBytes, 0, utf8Encoded.remaining());
                this.deferredFileOutputStream.write(convertedBytes, 0, convertedBytes.length);
            }
        } else {
            this.deferredFileOutputStream.write(buf, off, len);
        }
    }

    public long getByteCount() {
        return this.deferredFileOutputStream.getByteCount();
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.deferredFileOutputStream.close();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        if (this.closed) {
            this.deferredFileOutputStream.writeTo(out);
        }
    }

    public synchronized void free() {
        if (null != this.deferredFileOutputStream && null != this.deferredFileOutputStream.getFile()) {
            try {
                this.closed = true;
                this.deferredFileOutputStream.close();
                if (!this.deferredFileOutputStream.getFile().delete()) {
                    this.deferredFileOutputStream.getFile().deleteOnExit();
                }
            }
            catch (IOException ioe) {
                this.deferredFileOutputStream.getFile().deleteOnExit();
            }
        }
    }
}

