/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.providerapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.util.ReflectionUtils;

public final class ServiceLoader {
    @Nonnull
    public <T> Set<T> load(Class<T> clazz, ClassLoader classLoader) {
        try {
            HashSet implementations = new HashSet();
            for (String fullyQualifiedClassName : this.lookup(clazz, classLoader)) {
                Class<?> implClass = classLoader.loadClass(fullyQualifiedClassName);
                implementations.add(ReflectionUtils.getConstructor(implClass, (Class[])new Class[0]).newInstance(new Object[0]));
            }
            return implementations;
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Nonnull
    public Set<String> lookup(Class<?> clazz, ClassLoader classLoader) throws IOException {
        String resourceName = "META-INF/services/" + clazz.getName();
        if (classLoader == null) {
            return Collections.emptySet();
        }
        Enumeration<URL> urls = classLoader.getResources(resourceName);
        return ServiceLoader.lookupSpiImplementations(urls);
    }

    @Nonnull
    private static Set<String> lookupSpiImplementations(Enumeration<URL> urlEnumeration) throws IOException {
        HashSet<String> names = new HashSet<String>();
        block18: while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            BufferedReader reader = ServiceLoader.getReader(url);
            Throwable throwable = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    char cp;
                    int n;
                    int ci = line.indexOf(35);
                    if (ci >= 0) {
                        line = line.substring(0, ci);
                    }
                    if ((n = (line = line.trim()).length()) == 0) continue;
                    if (line.indexOf(32) >= 0 || line.indexOf(9) >= 0 || !Character.isJavaIdentifierStart(cp = line.charAt(0))) continue block18;
                    for (int i = 1; i < n; ++i) {
                        cp = line.charAt(i);
                        if (!Character.isJavaIdentifierPart(cp) && cp != '.') continue block18;
                    }
                    if (names.contains(line)) continue;
                    names.add(line);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        return names;
    }

    @Nonnull
    private static BufferedReader getReader(@Nonnull URL url) throws IOException {
        InputStream inputStream = url.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return new BufferedReader(inputStreamReader);
    }
}

