/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository;

import java.util.Map;
import java.util.Set;
import org.kurento.repository.service.pojo.RepositoryItemPlayer;
import org.kurento.repository.service.pojo.RepositoryItemRecorder;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.PUT;
import retrofit.http.Path;

public interface RepositoryClient {
    @POST(value="/repo/item")
    public RepositoryItemRecorder createRepositoryItem(@Body Map<String, String> var1);

    @DELETE(value="/repo/item/{itemId}")
    public Response removeRepositoryItem(@Path(value="itemId") String var1);

    @GET(value="/repo/item/{itemId}")
    public RepositoryItemPlayer getReadEndpoint(@Path(value="itemId") String var1);

    @POST(value="/repo/item/find")
    public Set<String> simpleFindItems(@Body Map<String, String> var1);

    @POST(value="/repo/item/find/regex")
    public Set<String> regexFindItems(@Body Map<String, String> var1);

    @GET(value="/repo/item/{itemId}/metadata")
    public Map<String, String> getRepositoryItemMetadata(@Path(value="itemId") String var1);

    @PUT(value="/repo/item/{itemId}/metadata")
    public Response setRepositoryItemMetadata(@Path(value="itemId") String var1, @Body Map<String, String> var2);
}

