/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.repository;

import com.google.common.base.StandardSystemProperty;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.kurento.repository.RepositoryClient;
import org.kurento.repository.RepositoryUrlLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;

public class RepositoryClientProvider {
    private static final Logger log = LoggerFactory.getLogger(RepositoryClientProvider.class);
    private static RepositoryUrlLoader repositoryUrlLoader;
    private RepositoryClient restService;

    public static RepositoryClientProvider createProvider() {
        return RepositoryClientProvider.createProvider(RepositoryClientProvider.getRepositoryUrl());
    }

    public static RepositoryClientProvider createProvider(String repoRestUrl) {
        RepositoryClientProvider provider = new RepositoryClientProvider();
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(repoRestUrl).build();
        provider.restService = (RepositoryClient)restAdapter.create(RepositoryClient.class);
        log.debug("Rest client service created for {}", (Object)repoRestUrl);
        return provider;
    }

    public static RepositoryClient create() {
        return RepositoryClientProvider.create(RepositoryClientProvider.getRepositoryUrl());
    }

    public static RepositoryClient create(String repoRestUrl) {
        return RepositoryClientProvider.createProvider(repoRestUrl).getRepositoryClient();
    }

    private RepositoryClientProvider() {
    }

    public RepositoryClient getRepositoryClient() {
        return this.restService;
    }

    private static synchronized String getRepositoryUrl() {
        if (repositoryUrlLoader == null) {
            Path configFile = Paths.get(StandardSystemProperty.USER_HOME.value(), ".kurento", "config.properties");
            repositoryUrlLoader = new RepositoryUrlLoader(configFile);
        }
        return repositoryUrlLoader.getRepositoryUrl();
    }
}

