/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnSetLock;
import org.tmatesoft.svn.core.wc2.SvnTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteSetLock
extends SvnRemoteOperationRunner<SVNLock, SvnSetLock>
implements ISVNLockHandler {
    @Override
    public boolean isApplicable(SvnSetLock operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.hasRemoteTargets();
    }

    @Override
    protected SVNLock run() throws SVNException {
        int i = 0;
        SVNURL[] urls = new SVNURL[((SvnSetLock)this.getOperation()).getTargets().size()];
        for (SvnTarget target : ((SvnSetLock)this.getOperation()).getTargets()) {
            urls[i++] = target.getURL();
        }
        SVNHashSet paths = new SVNHashSet();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        SVNHashMap pathsToRevisions = new SVNHashMap();
        for (String path : paths) {
            path = SVNEncodingUtil.uriDecode(path);
            pathsToRevisions.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.getRepositoryAccess().createRepository(topURL, null, true);
        repository.lock(pathsToRevisions, ((SvnSetLock)this.getOperation()).getLockMessage(), ((SvnSetLock)this.getOperation()).isStealLock(), this);
        return (SVNLock)((SvnSetLock)this.getOperation()).first();
    }

    @Override
    public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
        if (error != null) {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCK_FAILED, lock, error), -1.0);
        } else {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.LOCKED, lock, null), -1.0);
        }
    }

    @Override
    public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
    }
}

