/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.xml;

import java.io.File;
import java.util.Date;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVNXMLAnnotateHandler
extends AbstractXMLHandler
implements ISVNAnnotateHandler {
    public static final String PATH_ATTR = "path";
    public static final String REVISION_ATTR = "revision";
    public static final String DATE_TAG = "date";
    public static final String AUTHOR_TAG = "author";
    public static final String COMMIT_TAG = "commit";
    public static final String ENTRY_TAG = "entry";
    public static final String LINE_NUMBER_TAG = "line-number";
    public static final String TARGET_TAG = "target";
    public static final String BLAME_TAG = "blame";
    public static final String MERGED_TAG = "merged";
    private long myLineNumber;
    private boolean myIsUseMergeHistory;

    public SVNXMLAnnotateHandler(ContentHandler contentHandler) {
        this(contentHandler, null);
    }

    public SVNXMLAnnotateHandler(ContentHandler contentHandler, ISVNDebugLog log) {
        this(contentHandler, log, false);
    }

    public SVNXMLAnnotateHandler(ContentHandler contentHandler, ISVNDebugLog log, boolean isUseMergeHistory) {
        super(contentHandler, log);
        this.myIsUseMergeHistory = isUseMergeHistory;
    }

    protected String getHeaderName() {
        return BLAME_TAG;
    }

    public void startTarget(String pathOrURL) {
        this.myLineNumber = 1L;
        try {
            this.addAttribute(PATH_ATTR, pathOrURL);
            this.openTag(TARGET_TAG);
        }
        catch (SAXException e) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
        }
    }

    public void endTarget() {
        this.myLineNumber = 1L;
        try {
            this.closeTag(TARGET_TAG);
        }
        catch (SAXException e) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLine(Date date, long revision, String author, String line) throws SVNException {
        try {
            try {
                this.addAttribute(LINE_NUMBER_TAG, this.myLineNumber + "");
                this.openTag(ENTRY_TAG);
                if (revision >= 0L) {
                    this.addAttribute(REVISION_ATTR, revision + "");
                    this.openTag(COMMIT_TAG);
                    this.addTag(AUTHOR_TAG, author);
                    this.addTag(DATE_TAG, SVNDate.formatDate(date));
                    this.closeTag(COMMIT_TAG);
                }
                this.closeTag(ENTRY_TAG);
            }
            catch (SAXException e) {
                this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                Object var9_6 = null;
                ++this.myLineNumber;
            }
            Object var9_5 = null;
            ++this.myLineNumber;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            ++this.myLineNumber;
            throw throwable;
        }
    }

    public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
        try {
            this.addAttribute(LINE_NUMBER_TAG, ++lineNumber + "");
            this.openTag(ENTRY_TAG);
            if (revision >= 0L) {
                this.addAttribute(REVISION_ATTR, revision + "");
                this.openTag(COMMIT_TAG);
                this.addTag(AUTHOR_TAG, author);
                this.addTag(DATE_TAG, SVNDate.formatDate(date));
                this.closeTag(COMMIT_TAG);
            }
            if (this.myIsUseMergeHistory && mergedRevision >= 0L) {
                this.addAttribute(PATH_ATTR, mergedPath);
                this.openTag(MERGED_TAG);
                this.addAttribute(REVISION_ATTR, mergedRevision + "");
                this.openTag(COMMIT_TAG);
                this.addTag(AUTHOR_TAG, mergedAuthor);
                this.addTag(DATE_TAG, SVNDate.formatDate(mergedDate));
                this.closeTag(COMMIT_TAG);
                this.closeTag(MERGED_TAG);
            }
            this.closeTag(ENTRY_TAG);
        }
        catch (SAXException e) {
            this.getDebugLog().logSevere(SVNLogType.DEFAULT, e);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.XML_MALFORMED, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
    }

    public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
        return false;
    }

    public void handleEOF() {
    }
}

