/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.lifecycle;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.util.ReflectionUtils;
import com.atlassian.maven.plugin.clover.internal.lifecycle.MavenLifecycleAnalyzer;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

public class Maven3LifecycleAnalyzer
extends MavenLifecycleAnalyzer {
    public Maven3LifecycleAnalyzer(@NotNull LifecycleExecutor lifecycleExecutor, @NotNull MavenProject mavenProject, @NotNull MavenSession mavenSession) {
        super(lifecycleExecutor, mavenProject, mavenSession);
    }

    @Override
    public boolean isCompatibleVersion() {
        return this.isMaven3();
    }

    @Override
    public Set<String> getPhasesToBeExecuted() throws CloverException {
        try {
            return this.findGoalsToBeExecutedInMaven3();
        }
        catch (NoSuchMethodException ex) {
            throw new CloverException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new CloverException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new CloverException((Throwable)ex);
        }
    }

    protected boolean isMaven3() {
        try {
            this.lifecycleExecutor.getClass().getDeclaredMethod("calculateExecutionPlan", MavenSession.class, String[].class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @NotNull
    protected Set<String> findGoalsToBeExecutedInMaven3() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String[] tasks = (String[])Iterables.toArray((Iterable)this.mavenSession.getGoals(), String.class);
        Object plan = this.lifecycleExecutor_calculateExecutionPlan(this.lifecycleExecutor, this.mavenSession, tasks);
        return this.getPhasesFromMojoExecutions(this.mavenExecutionPlan_getMojoExecutions(plan));
    }

    private Object lifecycleExecutor_calculateExecutionPlan(@NotNull LifecycleExecutor lifecycleExecutor, MavenSession mavenSession, String[] tasks) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method calculateExecutionPlan = lifecycleExecutor.getClass().getDeclaredMethod("calculateExecutionPlan", MavenSession.class, String[].class);
        return calculateExecutionPlan.invoke((Object)lifecycleExecutor, mavenSession, tasks);
    }

    private List<MojoExecution> mavenExecutionPlan_getMojoExecutions(Object plan) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (List)ReflectionUtils.invokeVirtualImplicit((String)"getMojoExecutions", (Object)plan);
    }
}

