/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.license.download.LicenseDownloader;

public class Cache {
    private final Map<String, LicenseDownloader.LicenseDownloadResult> urlToFile = new HashMap<String, LicenseDownloader.LicenseDownloadResult>();
    private final Map<String, LicenseDownloader.LicenseDownloadResult> sha1ToFile = new HashMap<String, LicenseDownloader.LicenseDownloadResult>();
    private final boolean enforcingUniqueSha1s;

    public Cache(boolean enforcingUniqueSha1s) {
        this.enforcingUniqueSha1s = enforcingUniqueSha1s;
    }

    public LicenseDownloader.LicenseDownloadResult get(String url) {
        return this.urlToFile.get(url);
    }

    public void put(String url, LicenseDownloader.LicenseDownloadResult entry) {
        if (entry.isSuccess()) {
            String sha1 = entry.getSha1();
            File entryFile = entry.getFile();
            LicenseDownloader.LicenseDownloadResult existing = this.sha1ToFile.get(sha1);
            if (existing == null) {
                this.sha1ToFile.put(sha1, entry);
            } else if (this.enforcingUniqueSha1s && !existing.getFile().equals(entryFile)) {
                File existingFile = existing.getFile();
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, LicenseDownloader.LicenseDownloadResult> en : this.urlToFile.entrySet()) {
                    if (!existingFile.equals(en.getValue().getFile())) continue;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(en.getKey());
                }
                throw new IllegalStateException("URL '" + url + "' should belong to licenseUrlFileName having key '" + existingFile.getName() + "' together with URLs '" + sb.toString() + "'");
            }
        }
        this.urlToFile.put(url, entry);
    }
}

