/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderWithDependencies;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(T instance) {
        return new ConstantProvider(instance);
    }

    public static <T> Provider<T> guicify(javax.inject.Provider<T> provider) {
        if (provider instanceof Provider) {
            return (Provider)provider;
        }
        javax.inject.Provider delegate = (javax.inject.Provider)Preconditions.checkNotNull(provider, (Object)"provider");
        Set<InjectionPoint> injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        if (injectionPoints.isEmpty()) {
            return new GuicifiedProvider(delegate);
        }
        HashSet mutableDeps = Sets.newHashSet();
        for (InjectionPoint ip : injectionPoints) {
            mutableDeps.addAll(ip.getDependencies());
        }
        ImmutableSet dependencies = ImmutableSet.copyOf((Collection)mutableDeps);
        return new GuicifiedProviderWithDependencies((Set)dependencies, delegate);
    }

    private static final class GuicifiedProviderWithDependencies<T>
    extends GuicifiedProvider<T>
    implements ProviderWithDependencies<T> {
        private final Set<Dependency<?>> dependencies;

        private GuicifiedProviderWithDependencies(Set<Dependency<?>> dependencies, javax.inject.Provider<T> delegate) {
            super(delegate);
            this.dependencies = dependencies;
        }

        @Inject
        void initialize(Injector injector) {
            injector.injectMembers(this.delegate);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }
    }

    private static class GuicifiedProvider<T>
    implements Provider<T> {
        protected final javax.inject.Provider<T> delegate;

        private GuicifiedProvider(javax.inject.Provider<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return (T)this.delegate.get();
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.delegate));
            return new StringBuilder(11 + string.length()).append("guicified(").append(string).append(")").toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof GuicifiedProvider && Objects.equal(this.delegate, ((GuicifiedProvider)obj).delegate);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.delegate});
        }
    }

    private static final class ConstantProvider<T>
    implements Provider<T> {
        private final T instance;

        private ConstantProvider(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.instance));
            return new StringBuilder(4 + string.length()).append("of(").append(string).append(")").toString();
        }

        public boolean equals(Object obj) {
            return obj instanceof ConstantProvider && Objects.equal(this.instance, ((ConstantProvider)obj).instance);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.instance});
        }
    }
}

