/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.autoscaling.AmazonAutoScalingAsync;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeletePolicyRequest;
import com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest;
import com.amazonaws.services.autoscaling.model.DeleteTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.services.autoscaling.model.DescribePoliciesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsResult;
import com.amazonaws.services.autoscaling.model.DescribeTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeTagsResult;
import com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesResult;
import com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyResult;
import com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResult;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAutoScalingAsyncClient
extends AmazonAutoScalingClient
implements AmazonAutoScalingAsync {
    private ExecutorService executorService;

    public AmazonAutoScalingAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonAutoScalingAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync(final DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingGroupsResult>(){

            @Override
            public DescribeAutoScalingGroupsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAutoScalingGroups(describeAutoScalingGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync(final DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest, final AsyncHandler<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingGroupsResult>(){

            @Override
            public DescribeAutoScalingGroupsResult call() throws Exception {
                DescribeAutoScalingGroupsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAutoScalingGroups(describeAutoScalingGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAutoScalingGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableMetricsCollectionAsync(final EnableMetricsCollectionRequest enableMetricsCollectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.enableMetricsCollection(enableMetricsCollectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> enableMetricsCollectionAsync(final EnableMetricsCollectionRequest enableMetricsCollectionRequest, final AsyncHandler<EnableMetricsCollectionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.enableMetricsCollection(enableMetricsCollectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(enableMetricsCollectionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resumeProcessesAsync(final ResumeProcessesRequest resumeProcessesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.resumeProcesses(resumeProcessesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resumeProcessesAsync(final ResumeProcessesRequest resumeProcessesRequest, final AsyncHandler<ResumeProcessesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.resumeProcesses(resumeProcessesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(resumeProcessesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLaunchConfigurationAsync(final DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteLaunchConfiguration(deleteLaunchConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLaunchConfigurationAsync(final DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest, final AsyncHandler<DeleteLaunchConfigurationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.deleteLaunchConfiguration(deleteLaunchConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteLaunchConfigurationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribePoliciesResult> describePoliciesAsync(final DescribePoliciesRequest describePoliciesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePoliciesResult>(){

            @Override
            public DescribePoliciesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describePolicies(describePoliciesRequest);
            }
        });
    }

    @Override
    public Future<DescribePoliciesResult> describePoliciesAsync(final DescribePoliciesRequest describePoliciesRequest, final AsyncHandler<DescribePoliciesRequest, DescribePoliciesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePoliciesResult>(){

            @Override
            public DescribePoliciesResult call() throws Exception {
                DescribePoliciesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describePolicies(describePoliciesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describePoliciesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingProcessTypesResult> describeScalingProcessTypesAsync(final DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingProcessTypesResult>(){

            @Override
            public DescribeScalingProcessTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeScalingProcessTypes(describeScalingProcessTypesRequest);
            }
        });
    }

    @Override
    public Future<DescribeScalingProcessTypesResult> describeScalingProcessTypesAsync(final DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest, final AsyncHandler<DescribeScalingProcessTypesRequest, DescribeScalingProcessTypesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingProcessTypesResult>(){

            @Override
            public DescribeScalingProcessTypesResult call() throws Exception {
                DescribeScalingProcessTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeScalingProcessTypes(describeScalingProcessTypesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeScalingProcessTypesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createAutoScalingGroupAsync(final CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createAutoScalingGroup(createAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createAutoScalingGroupAsync(final CreateAutoScalingGroupRequest createAutoScalingGroupRequest, final AsyncHandler<CreateAutoScalingGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.createAutoScalingGroup(createAutoScalingGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createAutoScalingGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(final DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingActivitiesResult>(){

            @Override
            public DescribeScalingActivitiesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeScalingActivities(describeScalingActivitiesRequest);
            }
        });
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(final DescribeScalingActivitiesRequest describeScalingActivitiesRequest, final AsyncHandler<DescribeScalingActivitiesRequest, DescribeScalingActivitiesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingActivitiesResult>(){

            @Override
            public DescribeScalingActivitiesResult call() throws Exception {
                DescribeScalingActivitiesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeScalingActivities(describeScalingActivitiesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeScalingActivitiesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNotificationConfigurationsResult> describeNotificationConfigurationsAsync(final DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNotificationConfigurationsResult>(){

            @Override
            public DescribeNotificationConfigurationsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeNotificationConfigurations(describeNotificationConfigurationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeNotificationConfigurationsResult> describeNotificationConfigurationsAsync(final DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest, final AsyncHandler<DescribeNotificationConfigurationsRequest, DescribeNotificationConfigurationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNotificationConfigurationsResult>(){

            @Override
            public DescribeNotificationConfigurationsResult call() throws Exception {
                DescribeNotificationConfigurationsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeNotificationConfigurations(describeNotificationConfigurationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeNotificationConfigurationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTerminationPolicyTypesResult> describeTerminationPolicyTypesAsync(final DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTerminationPolicyTypesResult>(){

            @Override
            public DescribeTerminationPolicyTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeTerminationPolicyTypes(describeTerminationPolicyTypesRequest);
            }
        });
    }

    @Override
    public Future<DescribeTerminationPolicyTypesResult> describeTerminationPolicyTypesAsync(final DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest, final AsyncHandler<DescribeTerminationPolicyTypesRequest, DescribeTerminationPolicyTypesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTerminationPolicyTypesResult>(){

            @Override
            public DescribeTerminationPolicyTypesResult call() throws Exception {
                DescribeTerminationPolicyTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeTerminationPolicyTypes(describeTerminationPolicyTypesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeTerminationPolicyTypesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeTags(describeTagsRequest);
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeTags(describeTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeTagsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> executePolicyAsync(final ExecutePolicyRequest executePolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.executePolicy(executePolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> executePolicyAsync(final ExecutePolicyRequest executePolicyRequest, final AsyncHandler<ExecutePolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.executePolicy(executePolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(executePolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteTags(deleteTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest, final AsyncHandler<DeleteTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.deleteTags(deleteTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteTagsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<PutScalingPolicyResult> putScalingPolicyAsync(final PutScalingPolicyRequest putScalingPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutScalingPolicyResult>(){

            @Override
            public PutScalingPolicyResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.putScalingPolicy(putScalingPolicyRequest);
            }
        });
    }

    @Override
    public Future<PutScalingPolicyResult> putScalingPolicyAsync(final PutScalingPolicyRequest putScalingPolicyRequest, final AsyncHandler<PutScalingPolicyRequest, PutScalingPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutScalingPolicyResult>(){

            @Override
            public PutScalingPolicyResult call() throws Exception {
                PutScalingPolicyResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.putScalingPolicy(putScalingPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putScalingPolicyRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putNotificationConfigurationAsync(final PutNotificationConfigurationRequest putNotificationConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.putNotificationConfiguration(putNotificationConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putNotificationConfigurationAsync(final PutNotificationConfigurationRequest putNotificationConfigurationRequest, final AsyncHandler<PutNotificationConfigurationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.putNotificationConfiguration(putNotificationConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putNotificationConfigurationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePolicyAsync(final DeletePolicyRequest deletePolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deletePolicy(deletePolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deletePolicyAsync(final DeletePolicyRequest deletePolicyRequest, final AsyncHandler<DeletePolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.deletePolicy(deletePolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deletePolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNotificationConfigurationAsync(final DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteNotificationConfiguration(deleteNotificationConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNotificationConfigurationAsync(final DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest, final AsyncHandler<DeleteNotificationConfigurationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.deleteNotificationConfiguration(deleteNotificationConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteNotificationConfigurationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteScheduledActionAsync(final DeleteScheduledActionRequest deleteScheduledActionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteScheduledAction(deleteScheduledActionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteScheduledActionAsync(final DeleteScheduledActionRequest deleteScheduledActionRequest, final AsyncHandler<DeleteScheduledActionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.deleteScheduledAction(deleteScheduledActionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteScheduledActionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setInstanceHealthAsync(final SetInstanceHealthRequest setInstanceHealthRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.setInstanceHealth(setInstanceHealthRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setInstanceHealthAsync(final SetInstanceHealthRequest setInstanceHealthRequest, final AsyncHandler<SetInstanceHealthRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.setInstanceHealth(setInstanceHealthRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setInstanceHealthRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingNotificationTypesResult> describeAutoScalingNotificationTypesAsync(final DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingNotificationTypesResult>(){

            @Override
            public DescribeAutoScalingNotificationTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAutoScalingNotificationTypes(describeAutoScalingNotificationTypesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingNotificationTypesResult> describeAutoScalingNotificationTypesAsync(final DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest, final AsyncHandler<DescribeAutoScalingNotificationTypesRequest, DescribeAutoScalingNotificationTypesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingNotificationTypesResult>(){

            @Override
            public DescribeAutoScalingNotificationTypesResult call() throws Exception {
                DescribeAutoScalingNotificationTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAutoScalingNotificationTypes(describeAutoScalingNotificationTypesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAutoScalingNotificationTypesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createOrUpdateTagsAsync(final CreateOrUpdateTagsRequest createOrUpdateTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createOrUpdateTags(createOrUpdateTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createOrUpdateTagsAsync(final CreateOrUpdateTagsRequest createOrUpdateTagsRequest, final AsyncHandler<CreateOrUpdateTagsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.createOrUpdateTags(createOrUpdateTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createOrUpdateTagsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> suspendProcessesAsync(final SuspendProcessesRequest suspendProcessesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.suspendProcesses(suspendProcessesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> suspendProcessesAsync(final SuspendProcessesRequest suspendProcessesRequest, final AsyncHandler<SuspendProcessesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.suspendProcesses(suspendProcessesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(suspendProcessesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingInstancesResult> describeAutoScalingInstancesAsync(final DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingInstancesResult>(){

            @Override
            public DescribeAutoScalingInstancesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAutoScalingInstances(describeAutoScalingInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingInstancesResult> describeAutoScalingInstancesAsync(final DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest, final AsyncHandler<DescribeAutoScalingInstancesRequest, DescribeAutoScalingInstancesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingInstancesResult>(){

            @Override
            public DescribeAutoScalingInstancesResult call() throws Exception {
                DescribeAutoScalingInstancesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAutoScalingInstances(describeAutoScalingInstancesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAutoScalingInstancesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createLaunchConfigurationAsync(final CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createLaunchConfiguration(createLaunchConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createLaunchConfigurationAsync(final CreateLaunchConfigurationRequest createLaunchConfigurationRequest, final AsyncHandler<CreateLaunchConfigurationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.createLaunchConfiguration(createLaunchConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createLaunchConfigurationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAutoScalingGroupAsync(final DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteAutoScalingGroup(deleteAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAutoScalingGroupAsync(final DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest, final AsyncHandler<DeleteAutoScalingGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.deleteAutoScalingGroup(deleteAutoScalingGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteAutoScalingGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableMetricsCollectionAsync(final DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.disableMetricsCollection(disableMetricsCollectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> disableMetricsCollectionAsync(final DisableMetricsCollectionRequest disableMetricsCollectionRequest, final AsyncHandler<DisableMetricsCollectionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.disableMetricsCollection(disableMetricsCollectionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(disableMetricsCollectionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateAutoScalingGroupAsync(final UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.updateAutoScalingGroup(updateAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateAutoScalingGroupAsync(final UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest, final AsyncHandler<UpdateAutoScalingGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.updateAutoScalingGroup(updateAutoScalingGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateAutoScalingGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync(final DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLaunchConfigurationsResult>(){

            @Override
            public DescribeLaunchConfigurationsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeLaunchConfigurations(describeLaunchConfigurationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync(final DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest, final AsyncHandler<DescribeLaunchConfigurationsRequest, DescribeLaunchConfigurationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLaunchConfigurationsResult>(){

            @Override
            public DescribeLaunchConfigurationsResult call() throws Exception {
                DescribeLaunchConfigurationsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeLaunchConfigurations(describeLaunchConfigurationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeLaunchConfigurationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAdjustmentTypesResult> describeAdjustmentTypesAsync(final DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAdjustmentTypesResult>(){

            @Override
            public DescribeAdjustmentTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAdjustmentTypes(describeAdjustmentTypesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAdjustmentTypesResult> describeAdjustmentTypesAsync(final DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest, final AsyncHandler<DescribeAdjustmentTypesRequest, DescribeAdjustmentTypesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAdjustmentTypesResult>(){

            @Override
            public DescribeAdjustmentTypesResult call() throws Exception {
                DescribeAdjustmentTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAdjustmentTypes(describeAdjustmentTypesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAdjustmentTypesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(final DescribeScheduledActionsRequest describeScheduledActionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScheduledActionsResult>(){

            @Override
            public DescribeScheduledActionsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeScheduledActions(describeScheduledActionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(final DescribeScheduledActionsRequest describeScheduledActionsRequest, final AsyncHandler<DescribeScheduledActionsRequest, DescribeScheduledActionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScheduledActionsResult>(){

            @Override
            public DescribeScheduledActionsResult call() throws Exception {
                DescribeScheduledActionsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeScheduledActions(describeScheduledActionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeScheduledActionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putScheduledUpdateGroupActionAsync(final PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.putScheduledUpdateGroupAction(putScheduledUpdateGroupActionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putScheduledUpdateGroupActionAsync(final PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest, final AsyncHandler<PutScheduledUpdateGroupActionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.putScheduledUpdateGroupAction(putScheduledUpdateGroupActionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putScheduledUpdateGroupActionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeMetricCollectionTypesResult> describeMetricCollectionTypesAsync(final DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMetricCollectionTypesResult>(){

            @Override
            public DescribeMetricCollectionTypesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeMetricCollectionTypes(describeMetricCollectionTypesRequest);
            }
        });
    }

    @Override
    public Future<DescribeMetricCollectionTypesResult> describeMetricCollectionTypesAsync(final DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest, final AsyncHandler<DescribeMetricCollectionTypesRequest, DescribeMetricCollectionTypesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMetricCollectionTypesResult>(){

            @Override
            public DescribeMetricCollectionTypesResult call() throws Exception {
                DescribeMetricCollectionTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeMetricCollectionTypes(describeMetricCollectionTypesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeMetricCollectionTypesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setDesiredCapacityAsync(final SetDesiredCapacityRequest setDesiredCapacityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.setDesiredCapacity(setDesiredCapacityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setDesiredCapacityAsync(final SetDesiredCapacityRequest setDesiredCapacityRequest, final AsyncHandler<SetDesiredCapacityRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonAutoScalingAsyncClient.this.setDesiredCapacity(setDesiredCapacityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setDesiredCapacityRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<TerminateInstanceInAutoScalingGroupResult> terminateInstanceInAutoScalingGroupAsync(final TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateInstanceInAutoScalingGroupResult>(){

            @Override
            public TerminateInstanceInAutoScalingGroupResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.terminateInstanceInAutoScalingGroup(terminateInstanceInAutoScalingGroupRequest);
            }
        });
    }

    @Override
    public Future<TerminateInstanceInAutoScalingGroupResult> terminateInstanceInAutoScalingGroupAsync(final TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest, final AsyncHandler<TerminateInstanceInAutoScalingGroupRequest, TerminateInstanceInAutoScalingGroupResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateInstanceInAutoScalingGroupResult>(){

            @Override
            public TerminateInstanceInAutoScalingGroupResult call() throws Exception {
                TerminateInstanceInAutoScalingGroupResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.terminateInstanceInAutoScalingGroup(terminateInstanceInAutoScalingGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(terminateInstanceInAutoScalingGroupRequest, result);
                return result;
            }
        });
    }
}

