/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyInstanceGroupsRequestMarshaller
implements Marshaller<Request<ModifyInstanceGroupsRequest>, ModifyInstanceGroupsRequest> {
    @Override
    public Request<ModifyInstanceGroupsRequest> marshall(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) {
        if (modifyInstanceGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyInstanceGroupsRequest> request = new DefaultRequest<ModifyInstanceGroupsRequest>(modifyInstanceGroupsRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.ModifyInstanceGroups";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag instanceGroupsList = (ListWithAutoConstructFlag)modifyInstanceGroupsRequest.getInstanceGroups();
            if (!(instanceGroupsList == null || instanceGroupsList.isAutoConstruct() && instanceGroupsList.isEmpty())) {
                jsonWriter.key("InstanceGroups");
                jsonWriter.array();
                for (InstanceGroupModifyConfig instanceGroupsListValue : instanceGroupsList) {
                    ListWithAutoConstructFlag eC2InstanceIdsToTerminateList;
                    if (instanceGroupsListValue == null) continue;
                    jsonWriter.object();
                    if (instanceGroupsListValue.getInstanceGroupId() != null) {
                        jsonWriter.key("InstanceGroupId").value(instanceGroupsListValue.getInstanceGroupId());
                    }
                    if (instanceGroupsListValue.getInstanceCount() != null) {
                        jsonWriter.key("InstanceCount").value(instanceGroupsListValue.getInstanceCount());
                    }
                    if (!((eC2InstanceIdsToTerminateList = (ListWithAutoConstructFlag)instanceGroupsListValue.getEC2InstanceIdsToTerminate()) == null || eC2InstanceIdsToTerminateList.isAutoConstruct() && eC2InstanceIdsToTerminateList.isEmpty())) {
                        jsonWriter.key("EC2InstanceIdsToTerminate");
                        jsonWriter.array();
                        for (String eC2InstanceIdsToTerminateListValue : eC2InstanceIdsToTerminateList) {
                            if (eC2InstanceIdsToTerminateListValue == null) continue;
                            jsonWriter.value(eC2InstanceIdsToTerminateListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

