/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.eclipse.writers.rad.RadApplicationXMLWriter;
import org.apache.maven.plugin.eclipse.writers.rad.RadEjbClasspathWriter;
import org.apache.maven.plugin.eclipse.writers.rad.RadJ2EEWriter;
import org.apache.maven.plugin.eclipse.writers.rad.RadLibCopier;
import org.apache.maven.plugin.eclipse.writers.rad.RadManifestWriter;
import org.apache.maven.plugin.eclipse.writers.rad.RadWebSettingsWriter;
import org.apache.maven.plugin.eclipse.writers.rad.RadWebsiteConfigWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="rad")
@Execute(phase=LifecyclePhase.GENERATE_RESOURCES)
public class RadPlugin
extends EclipsePlugin {
    private static final String COM_IBM_ETOOLS_J2EE_UI_LIB_DIR_BUILDER = "com.ibm.etools.j2ee.ui.LibDirBuilder";
    private static final String COM_IBM_ETOOLS_SITEEDIT_SITE_NAV_BUILDER = "com.ibm.etools.siteedit.SiteNavBuilder";
    private static final String COM_IBM_ETOOLS_SITEEDIT_SITE_UPDATE_BUILDER = "com.ibm.etools.siteedit.SiteUpdateBuilder";
    private static final String COM_IBM_ETOOLS_SITEEDIT_WEB_SITE_NATURE = "com.ibm.etools.siteedit.WebSiteNature";
    private static final String COM_IBM_ETOOLS_VALIDATION_VALIDATIONBUILDER = "com.ibm.etools.validation.validationbuilder";
    private static final String COM_IBM_ETOOLS_WEBPAGE_TEMPLATE_TEMPLATEBUILDER = "com.ibm.etools.webpage.template.templatebuilder";
    private static final String COM_IBM_ETOOLS_WEBPAGE_TEMPLATE_TEMPLATENATURE = "com.ibm.etools.webpage.template.templatenature";
    private static final String COM_IBM_ETOOLS_WEBTOOLS_ADDITIONS_JSPCOMPILATIONBUILDER = "com.ibm.etools.webtools.additions.jspcompilationbuilder";
    private static final String COM_IBM_ETOOLS_WEBTOOLS_ADDITIONS_LINKSBUILDER = "com.ibm.etools.webtools.additions.linksbuilder";
    private static final String COM_IBM_SSE_MODEL_STRUCTUREDBUILDER = "com.ibm.sse.model.structuredbuilder";
    private static final String COM_IBM_WTP_EJB_EJBNATURE = "com.ibm.wtp.ejb.EJBNature";
    private static final String COM_IBM_WTP_J2EE_EARNATURE = "com.ibm.wtp.j2ee.EARNature";
    private static final String COM_IBM_WTP_J2EE_LIB_COPY_BUILDER = "com.ibm.wtp.j2ee.LibCopyBuilder";
    private static final String COM_IBM_WTP_MIGRATION_MIGRATION_BUILDER = "com.ibm.wtp.migration.MigrationBuilder";
    private static final String COM_IBM_WTP_WEB_WEB_NATURE = "com.ibm.wtp.web.WebNature";
    private static final String NO_GENERATED_RESOURCE_DIRNAME = "none";
    private static final String ORG_ECLIPSE_JDT_CORE_JAVABUILDER = "org.eclipse.jdt.core.javabuilder";
    private static final String ORG_ECLIPSE_JDT_CORE_JAVANATURE = "org.eclipse.jdt.core.javanature";
    @Parameter
    private String warContextRoot;
    @Parameter(property="generatedResourceDirName", defaultValue="target/generated-resources/rad6")
    private String generatedResourceDirName;

    public String getWarContextRoot() {
        return this.warContextRoot;
    }

    public void setWarContextRoot(String warContextRoot) {
        this.warContextRoot = warContextRoot;
    }

    protected void writeConfigurationExtras(EclipseWriterConfig config) throws MojoExecutionException {
        super.writeConfigurationExtras(config);
        new RadJ2EEWriter().init(this.getLog(), config).write();
        new RadWebSettingsWriter(this.warContextRoot).init(this.getLog(), config).write();
        new RadWebsiteConfigWriter().init(this.getLog(), config).write();
        new RadApplicationXMLWriter().init(this.getLog(), config).write();
        new RadLibCopier().init(this.getLog(), config).write();
        new RadEjbClasspathWriter().init(this.getLog(), config).write();
    }

    private void addManifestResource(EclipseWriterConfig config) throws MojoExecutionException {
        if (this.isJavaProject()) {
            new RadManifestWriter().init(this.getLog(), config).write();
        }
        if (!(!this.isJavaProject() || "ear".equals(this.packaging) || "war".equals(this.packaging) || "ejb".equals(this.packaging) || NO_GENERATED_RESOURCE_DIRNAME.equals(this.generatedResourceDirName))) {
            String generatedResourceDir = this.project.getBasedir().getAbsolutePath() + File.separatorChar + this.generatedResourceDirName;
            String metainfDir = generatedResourceDir + File.separatorChar + "META-INF";
            new File(metainfDir).mkdirs();
            Resource resource = new Resource();
            this.getLog().debug((CharSequence)("Adding " + this.generatedResourceDirName + " to resources"));
            resource.setDirectory(generatedResourceDir);
            this.executedProject.addResource(resource);
        }
        if ("war".equals(this.packaging)) {
            new File(RadPlugin.getWebContentBaseDirectory(config) + File.separatorChar + "META-INF").mkdirs();
        }
    }

    private static String getWebContentBaseDirectory(EclipseWriterConfig config) throws MojoExecutionException {
        File warSourceDirectory = new File(IdeUtils.getPluginSetting(config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", "src/main/webapp"));
        String webContentDir = IdeUtils.toRelativeAndFixSeparator(config.getEclipseProjectDirectory(), warSourceDirectory, false);
        String result = config.getProject().getBasedir().getAbsolutePath() + File.separatorChar + webContentDir;
        return result;
    }

    protected void fillDefaultBuilders(String packaging) {
        super.fillDefaultBuilders(packaging);
        ArrayList<String> buildcommands = new ArrayList<String>();
        if ("ear".equals(packaging)) {
            buildcommands.add(COM_IBM_ETOOLS_VALIDATION_VALIDATIONBUILDER);
            buildcommands.add(COM_IBM_SSE_MODEL_STRUCTUREDBUILDER);
        } else if ("war".equals(packaging)) {
            buildcommands.add(COM_IBM_WTP_MIGRATION_MIGRATION_BUILDER);
            buildcommands.add(ORG_ECLIPSE_JDT_CORE_JAVABUILDER);
            buildcommands.add(COM_IBM_ETOOLS_J2EE_UI_LIB_DIR_BUILDER);
            buildcommands.add(COM_IBM_ETOOLS_WEBTOOLS_ADDITIONS_LINKSBUILDER);
            buildcommands.add(COM_IBM_ETOOLS_WEBPAGE_TEMPLATE_TEMPLATEBUILDER);
            buildcommands.add(COM_IBM_ETOOLS_SITEEDIT_SITE_NAV_BUILDER);
            buildcommands.add(COM_IBM_ETOOLS_SITEEDIT_SITE_UPDATE_BUILDER);
            buildcommands.add(COM_IBM_ETOOLS_VALIDATION_VALIDATIONBUILDER);
            buildcommands.add(COM_IBM_WTP_J2EE_LIB_COPY_BUILDER);
            buildcommands.add(COM_IBM_ETOOLS_WEBTOOLS_ADDITIONS_JSPCOMPILATIONBUILDER);
            buildcommands.add(COM_IBM_SSE_MODEL_STRUCTUREDBUILDER);
        } else if ("ejb".equals(packaging)) {
            buildcommands.add(ORG_ECLIPSE_JDT_CORE_JAVABUILDER);
            buildcommands.add(COM_IBM_ETOOLS_VALIDATION_VALIDATIONBUILDER);
            buildcommands.add(COM_IBM_WTP_J2EE_LIB_COPY_BUILDER);
            buildcommands.add(COM_IBM_SSE_MODEL_STRUCTUREDBUILDER);
        } else if (this.isJavaProject()) {
            buildcommands.add(ORG_ECLIPSE_JDT_CORE_JAVABUILDER);
            buildcommands.add(COM_IBM_SSE_MODEL_STRUCTUREDBUILDER);
        }
        this.setBuildcommands(buildcommands);
    }

    protected void fillDefaultNatures(String packaging) {
        super.fillDefaultNatures(packaging);
        ArrayList<String> projectnatures = new ArrayList<String>();
        if ("ear".equals(packaging)) {
            projectnatures.add(COM_IBM_WTP_J2EE_EARNATURE);
        } else if ("war".equals(packaging)) {
            projectnatures.add(COM_IBM_WTP_WEB_WEB_NATURE);
            projectnatures.add(ORG_ECLIPSE_JDT_CORE_JAVANATURE);
            projectnatures.add(COM_IBM_ETOOLS_SITEEDIT_WEB_SITE_NATURE);
            projectnatures.add(COM_IBM_ETOOLS_WEBPAGE_TEMPLATE_TEMPLATENATURE);
        } else if ("ejb".equals(packaging)) {
            projectnatures.add(COM_IBM_WTP_EJB_EJBNATURE);
            projectnatures.add(ORG_ECLIPSE_JDT_CORE_JAVANATURE);
        } else if (this.isJavaProject()) {
            projectnatures.add(ORG_ECLIPSE_JDT_CORE_JAVANATURE);
        }
        this.setProjectnatures(projectnatures);
    }

    protected boolean isAvailableAsAReactorProject(Artifact artifact) {
        if (this.reactorProjects != null && ("jar".equals(artifact.getType()) || "ejb".equals(artifact.getType()) || "war".equals(artifact.getType()))) {
            for (Object reactorProject1 : this.reactorProjects) {
                MavenProject reactorProject = (MavenProject)reactorProject1;
                if (!reactorProject.getGroupId().equals(artifact.getGroupId()) || !reactorProject.getArtifactId().equals(artifact.getArtifactId())) continue;
                if (reactorProject.getVersion().equals(artifact.getVersion())) {
                    return true;
                }
                this.getLog().info((CharSequence)("Artifact " + artifact.getId() + " already available as a reactor project, but with different version. Expected: " + artifact.getVersion() + ", found: " + reactorProject.getVersion()));
            }
        }
        return false;
    }

    protected void setupExtras() throws MojoExecutionException {
        super.setupExtras();
        IdeDependency[] deps = this.doDependencyResolution();
        EclipseWriterConfig config = this.createEclipseWriterConfig(deps);
        this.addManifestResource(config);
    }

    public String getProjectNameForArifact(Artifact artifact) {
        return artifact.getArtifactId();
    }
}

