/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.concurrent.CountDownLatch;
import org.apache.maven.lifecycle.Schedule;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;

public class ExecutionPlanItem {
    private final MojoExecution mojoExecution;
    private final Schedule schedule;
    private final CountDownLatch done = new CountDownLatch(1);

    public ExecutionPlanItem(MojoExecution mojoExecution, Schedule schedule) {
        this.mojoExecution = mojoExecution;
        this.schedule = schedule;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public String getLifecyclePhase() {
        return this.mojoExecution.getLifecyclePhase();
    }

    public void setComplete() {
        this.done.countDown();
    }

    public boolean isDone() {
        return this.done.getCount() < 1L;
    }

    public void forceComplete() {
        this.setComplete();
    }

    public void waitUntilDone() throws InterruptedException {
        this.done.await();
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Plugin getPlugin() {
        MojoDescriptor mojoDescriptor = this.getMojoExecution().getMojoDescriptor();
        return mojoDescriptor.getPluginDescriptor().getPlugin();
    }

    public String toString() {
        return "ExecutionPlanItem{, mojoExecution=" + this.mojoExecution + ", schedule=" + this.schedule + '}' + super.toString();
    }
}

