/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.internal.server.BeanCreatingHelper;
import org.kurento.jsonrpc.message.Request;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.Assert;
import org.springframework.web.socket.handler.PerConnectionWebSocketHandler;

public class PerSessionJsonRpcHandler<T>
implements JsonRpcHandler<T>,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(PerConnectionWebSocketHandler.class);
    private final BeanCreatingHelper<JsonRpcHandler<T>> provider;
    private final Map<Session, JsonRpcHandler<T>> handlers = new ConcurrentHashMap<Session, JsonRpcHandler<T>>();
    private boolean useSockJS;
    private String label;
    private List<String> allowedOrigins = ImmutableList.of();
    private List<Object> interceptors = ImmutableList.of();
    private boolean pingWachdog;

    public PerSessionJsonRpcHandler(String handlerName) {
        this(handlerName, null);
    }

    public PerSessionJsonRpcHandler(Class<? extends JsonRpcHandler<T>> handlerType) {
        this(null, handlerType);
    }

    public PerSessionJsonRpcHandler(String handlerName, Class<? extends JsonRpcHandler<T>> handlerType) {
        this.provider = new BeanCreatingHelper<JsonRpcHandler<JsonRpcHandler<T>>>(handlerType, handlerName);
    }

    public Class<? extends JsonRpcHandler<T>> getHandlerType() {
        Class<?> clazz = this.provider.getCreatedBeanType();
        if (clazz == null) {
            this.provider.createBean();
            clazz = this.provider.getCreatedBeanType();
        }
        return clazz;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.provider.setBeanFactory(beanFactory);
    }

    public void handleRequest(Transaction transaction, Request<T> request) throws Exception {
        JsonRpcHandler<T> handler = this.getHandler(transaction.getSession());
        Assert.isTrue((handler != null ? 1 : 0) != 0, (String)("Handler of class " + this.provider.getClass() + " can't be created. Be sure that there is a bean registered of this type"));
        try {
            handler.handleRequest(transaction, request);
        }
        catch (Exception e) {
            handler.handleUncaughtException(transaction.getSession(), e);
        }
    }

    private JsonRpcHandler<T> getHandler(Session session) {
        JsonRpcHandler<T> handler = this.handlers.get(session);
        Assert.isTrue((handler != null ? 1 : 0) != 0, (String)("JsonRpcHandler not found for " + session));
        return handler;
    }

    public void afterConnectionEstablished(Session session) throws Exception {
        JsonRpcHandler<T> handler = this.provider.createBean();
        this.handlers.put(session, handler);
        try {
            handler.afterConnectionEstablished(session);
        }
        catch (Exception e) {
            handler.handleUncaughtException(session, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(Session session, String status) throws Exception {
        try {
            JsonRpcHandler<T> handler = this.getHandler(session);
            try {
                handler.afterConnectionClosed(session, status);
            }
            catch (Exception e) {
                handler.handleUncaughtException(session, e);
            }
        }
        finally {
            this.destroy(session);
        }
    }

    private void destroy(Session session) {
        JsonRpcHandler<T> handler = this.handlers.remove(session);
        try {
            if (handler != null) {
                this.provider.destroy(handler);
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"Error while destroying handler", t);
        }
    }

    public void handleTransportError(Session session, Throwable exception) throws Exception {
        JsonRpcHandler<T> handler = this.getHandler(session);
        try {
            handler.handleTransportError(session, exception);
        }
        catch (Exception e) {
            handler.handleUncaughtException(session, e);
        }
    }

    public void handleUncaughtException(Session session, Exception exception) {
        logger.error((Object)"Uncaught exception while execution PerSessionJsonRpcHandler", (Throwable)exception);
    }

    public PerSessionJsonRpcHandler<T> withSockJS() {
        this.useSockJS = true;
        return this;
    }

    public boolean isSockJSEnabled() {
        return this.useSockJS;
    }

    public PerSessionJsonRpcHandler<T> withLabel(String label) {
        this.label = label;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public PerSessionJsonRpcHandler<T> withPingWachdog(boolean pingAsWachdog) {
        this.pingWachdog = pingAsWachdog;
        return this;
    }

    public boolean isPingWatchdog() {
        return this.pingWachdog;
    }

    public final PerSessionJsonRpcHandler<T> withAllowedOrigins(String ... origins) {
        this.allowedOrigins = ImmutableList.copyOf((Object[])origins);
        return this;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public JsonRpcHandler<T> withInterceptors(Object ... interceptors) {
        this.interceptors = ImmutableList.copyOf((Object[])interceptors);
        return this;
    }

    public List<Object> interceptors() {
        return this.interceptors;
    }
}

