/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.ws;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.kurento.commons.PropertiesManager;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.server.ProtocolManager;
import org.kurento.jsonrpc.internal.server.ServerSession;
import org.kurento.jsonrpc.internal.server.SessionsManager;
import org.kurento.jsonrpc.internal.ws.CloseStatusHelper;
import org.kurento.jsonrpc.internal.ws.WebSocketServerSession;
import org.kurento.jsonrpc.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class JsonRpcWebSocketHandler
extends TextWebSocketHandler {
    private static final long MAX_WS_CONNECTIONS = PropertiesManager.getProperty((String)"ws.maxSessions", (long)Long.MAX_VALUE);
    private static final AtomicLong numConnections = new AtomicLong();
    private static final Logger log = LoggerFactory.getLogger(JsonRpcWebSocketHandler.class);
    private final ProtocolManager protocolManager;
    private String label = "";

    public JsonRpcWebSocketHandler(ProtocolManager protocolManager) {
        this.protocolManager = protocolManager;
    }

    public void setLabel(String label) {
        this.label = "[" + label + "] ";
        this.protocolManager.setLabel(label);
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        try {
            this.incNumConnectionsIfAllowed();
        }
        catch (MaxNumberWsConnectionsReachedException e) {
            log.warn("Closed a WS connection because MAX_WS_CONNECTIONS={} limit reached", (Object)MAX_WS_CONNECTIONS);
            session.close();
        }
        try {
            log.debug("{} Client connection established from session={} uri={} headers={} acceptedProtocol={} attributes={}", new Object[]{this.label, session.getRemoteAddress(), session.getUri(), session.getHandshakeHeaders(), session.getAcceptedProtocol(), session.getAttributes()});
        }
        catch (Throwable t) {
            log.error("{} Exception processing afterConnectionEstablished in session={}", new Object[]{this.label, session.getId(), t});
        }
    }

    private void incNumConnectionsIfAllowed() throws MaxNumberWsConnectionsReachedException {
        long curNumConn;
        boolean setSuccessful;
        do {
            if ((curNumConn = numConnections.get()) < MAX_WS_CONNECTIONS) continue;
            throw new MaxNumberWsConnectionsReachedException();
        } while (!(setSuccessful = numConnections.compareAndSet(curNumConn, curNumConn + 1L)));
    }

    public void afterConnectionClosed(WebSocketSession wsSession, CloseStatus status) throws Exception {
        numConnections.decrementAndGet();
        try {
            ServerSession session = (ServerSession)this.protocolManager.getSessionByTransportId(wsSession.getId());
            if (session != null) {
                if (session.isGracefullyClosed()) {
                    log.debug("{} WebSocket session {} with transportId {} closed gracefully", new Object[]{this.label, session.getSessionId(), wsSession.getId()});
                } else {
                    log.debug("{} WebSocket session {} with transportId {} closed for {} (code {}, reason '{}')", new Object[]{this.label, session.getSessionId(), wsSession.getId(), CloseStatusHelper.getCloseStatusType(status.getCode()), status.getCode(), status.getReason()});
                    this.protocolManager.closeSessionIfTimeout(wsSession.getId(), status.getReason());
                }
            } else {
                log.debug("{} WebSocket session not associated to any jsonRpcSession with transportId {} closed for {} (code {}, reason '{}')", new Object[]{this.label, wsSession.getId(), CloseStatusHelper.getCloseStatusType(status.getCode()), status.getCode(), status.getReason()});
            }
        }
        catch (Throwable t) {
            log.error("{} Exception processing afterConnectionClosed in session={}", new Object[]{this.label, wsSession.getId(), t});
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        try {
            this.protocolManager.processTransportError(session.getId(), exception);
        }
        catch (Throwable t) {
            log.error(this.label + "Exception processing transportError in session={}", (Object)session.getId(), (Object)t);
        }
    }

    public void handleTextMessage(final WebSocketSession wsSession, TextMessage message) throws Exception {
        try {
            String messageJson = (String)message.getPayload();
            ProtocolManager.ServerSessionFactory factory = new ProtocolManager.ServerSessionFactory(){

                @Override
                public ServerSession createSession(String sessionId, Object registerInfo, SessionsManager sessionsManager) {
                    return new WebSocketServerSession(sessionId, registerInfo, sessionsManager, wsSession);
                }

                @Override
                public void updateSessionOnReconnection(ServerSession session) {
                    ((WebSocketServerSession)session).updateWebSocketSession(wsSession);
                }
            };
            this.protocolManager.processMessage(messageJson, factory, new TransactionImpl.ResponseSender(){

                public void sendResponse(Message message) throws IOException {
                    String jsonMessage = message.toString();
                    log.debug("{} Res<- {}", (Object)JsonRpcWebSocketHandler.this.label, (Object)jsonMessage);
                    this.sendJsonMessage(jsonMessage);
                }

                public void sendPingResponse(Message message) throws IOException {
                    String jsonMessage = message.toString();
                    log.trace("{} Res<- {}", (Object)JsonRpcWebSocketHandler.this.label, (Object)jsonMessage);
                    this.sendJsonMessage(jsonMessage);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void sendJsonMessage(String jsonMessage) throws IOException {
                    WebSocketSession webSocketSession = wsSession;
                    synchronized (webSocketSession) {
                        if (wsSession.isOpen()) {
                            wsSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)jsonMessage));
                        } else {
                            log.error("Trying to send a message to a closed session");
                        }
                    }
                }
            }, wsSession.getId());
        }
        catch (Throwable t) {
            log.error("{} Exception processing request {}.", new Object[]{this.label, message.getPayload(), t});
        }
    }

    public class MaxNumberWsConnectionsReachedException
    extends Exception {
        private static final long serialVersionUID = -6621614523181088993L;
    }
}

