/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.tasks;

import java.io.File;
import java.util.Collections;
import java.util.List;
import net.sourceforge.cobertura.reporting.ReportMain;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.cobertura.tasks.AbstractTask;
import org.codehaus.plexus.util.StringUtils;

public class ReportTask
extends AbstractTask {
    private File dataFile;
    private File outputDirectory;
    private String outputFormat;
    private String sourceEncoding;
    private List<String> compileSourceRoots;

    public ReportTask() {
        super(ReportMain.class.getName());
    }

    @Override
    public void execute() throws MojoExecutionException {
        int returnCode;
        this.outputDirectory.mkdirs();
        for (String directory : this.compileSourceRoots) {
            this.cmdLineArgs.addArg("--source", directory);
        }
        if (this.outputDirectory != null) {
            this.cmdLineArgs.addArg("--destination", this.outputDirectory.getAbsolutePath());
        }
        if (this.dataFile != null) {
            this.cmdLineArgs.addArg("--datafile", this.dataFile.getAbsolutePath());
        }
        if (StringUtils.isNotEmpty((String)this.outputFormat)) {
            this.cmdLineArgs.addArg("--format", this.outputFormat);
        }
        if (StringUtils.isNotEmpty((String)this.sourceEncoding)) {
            this.cmdLineArgs.addArg("--encoding", this.sourceEncoding);
        }
        if ((returnCode = this.executeJava()) != 0) {
            throw new MojoExecutionException("Unable to generate Cobertura Report for project.");
        }
        this.getLog().info((CharSequence)"Cobertura Report generation was successful.");
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setCompileSourceRoots(List<String> compileSourceRoots) {
        this.compileSourceRoots = Collections.unmodifiableList(compileSourceRoots);
    }
}

