/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Date;

public final class JacksonConf {
    public static ObjectMapper DEFAULT_INSTANCE = JacksonConf.createDefaultObjectMapper();

    private static ObjectMapper createDefaultObjectMapper() {
        SimpleModule simpleModule = new SimpleModule("Lambdify");
        simpleModule.addDeserializer(Date.class, (JsonDeserializer)new DateCustomDeserializer());
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true).registerModule((Module)simpleModule);
    }

    private JacksonConf() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class DateCustomDeserializer
    extends DateDeserializers.DateDeserializer {
        private DateCustomDeserializer() {
        }

        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            switch (jsonParser.getCurrentTokenId()) {
                case 8: {
                    try {
                        return new Date(jsonParser.getLongValue());
                    }
                    catch (Throwable throwable) {
                        return super.deserialize(jsonParser, deserializationContext);
                    }
                }
            }
            return super.deserialize(jsonParser, deserializationContext);
        }
    }
}

