/*
 * Decompiled with CFR 0.152.
 */
package lambdify.mojo;

import com.amazonaws.services.apigateway.AmazonApiGateway;
import com.amazonaws.services.apigateway.model.ContentHandlingStrategy;
import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.amazonaws.services.apigateway.model.CreateResourceRequest;
import com.amazonaws.services.apigateway.model.CreateResourceResult;
import com.amazonaws.services.apigateway.model.CreateRestApiRequest;
import com.amazonaws.services.apigateway.model.CreateRestApiResult;
import com.amazonaws.services.apigateway.model.DeleteRestApiRequest;
import com.amazonaws.services.apigateway.model.GetResourcesRequest;
import com.amazonaws.services.apigateway.model.GetRestApisRequest;
import com.amazonaws.services.apigateway.model.IntegrationType;
import com.amazonaws.services.apigateway.model.PutIntegrationRequest;
import com.amazonaws.services.apigateway.model.PutMethodRequest;
import com.amazonaws.services.apigateway.model.Resource;
import com.amazonaws.services.apigateway.model.RestApi;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.AddPermissionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.CreateFunctionResult;
import com.amazonaws.services.lambda.model.DeleteFunctionRequest;
import com.amazonaws.services.lambda.model.FunctionCode;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.services.lambda.model.ResourceNotFoundException;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

class AWS {
    AWSLambda lambda;
    AmazonApiGateway apiGateway;
    AWSSecurityTokenService sts;

    AWS() {
    }

    String getMyAccountId() {
        try {
            GetCallerIdentityResult getCallerIdentityResult = this.sts.getCallerIdentity(new GetCallerIdentityRequest());
            String string = getCallerIdentityResult.getAccount();
            return string;
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RestApi getRestApi(String string) {
        try {
            List list = this.apiGateway.getRestApis(new GetRestApisRequest().withLimit(Integer.valueOf(500))).getItems();
            RestApi restApi2 = AWS.first(list, restApi -> string.equals(restApi.getName()));
            return restApi2;
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPermissionToInvokeLambdaFunctions(String string, String string2) {
        this.removePermissionToInvokeLambdaFunction(string);
        try {
            AddPermissionRequest addPermissionRequest = new AddPermissionRequest().withPrincipal("apigateway.amazonaws.com").withFunctionName(string).withStatementId(string + "-lambda-InvokeFunction").withAction("lambda:InvokeFunction").withSourceArn(string2);
            this.lambda.addPermission(addPermissionRequest);
        }
        finally {
            AWS.await();
        }
    }

    private void removePermissionToInvokeLambdaFunction(String string) {
        try {
            RemovePermissionRequest removePermissionRequest = new RemovePermissionRequest().withFunctionName(string).withStatementId(string + "-lambda-InvokeFunction");
            this.lambda.removePermission(removePermissionRequest);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
        }
        finally {
            AWS.await();
        }
    }

    void deleteRestApi(String string) {
        try {
            DeleteRestApiRequest deleteRestApiRequest = new DeleteRestApiRequest().withRestApiId(string);
            this.apiGateway.deleteRestApi(deleteRestApiRequest);
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assignLambdaToResource(String string, String string2, String string3, String string4) {
        try {
            PutIntegrationRequest putIntegrationRequest = new PutIntegrationRequest().withRestApiId(string).withResourceId(string2).withUri("arn:aws:apigateway:" + string4 + ":lambda:path/2015-03-31/functions/" + string3 + "/invocations").withHttpMethod("ANY").withType(IntegrationType.AWS_PROXY).withContentHandling(ContentHandlingStrategy.CONVERT_TO_TEXT).withIntegrationHttpMethod("POST");
            this.apiGateway.putIntegration(putIntegrationRequest);
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GetFunctionResult getFunction(String string) {
        try {
            GetFunctionRequest getFunctionRequest = new GetFunctionRequest().withFunctionName(string);
            GetFunctionResult getFunctionResult = this.lambda.getFunction(getFunctionRequest);
            return getFunctionResult;
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CreateFunctionResult createFunction(String string, String string2, String string3, String string4, int n, int n2, String string5) {
        try {
            FunctionCode functionCode = new FunctionCode().withS3Bucket(string3).withS3Key(string4);
            CreateFunctionRequest createFunctionRequest = new CreateFunctionRequest().withFunctionName(string).withCode(functionCode).withRole(string5).withRuntime(Runtime.Java8).withHandler(string2).withTimeout(Integer.valueOf(n)).withMemorySize(Integer.valueOf(n2));
            CreateFunctionResult createFunctionResult = this.lambda.createFunction(createFunctionRequest);
            return createFunctionResult;
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFunction(String string, String string2, String string3) {
        try {
            UpdateFunctionCodeRequest updateFunctionCodeRequest = new UpdateFunctionCodeRequest().withFunctionName(string).withS3Bucket(string2).withS3Key(string3);
            this.lambda.updateFunctionCode(updateFunctionCodeRequest);
        }
        finally {
            AWS.await();
        }
    }

    void deleteFunction(String string) {
        try {
            DeleteFunctionRequest deleteFunctionRequest = new DeleteFunctionRequest().withFunctionName(string);
            this.lambda.deleteFunction(deleteFunctionRequest);
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CreateRestApiResult createRestApi(String string) {
        try {
            CreateRestApiRequest createRestApiRequest = new CreateRestApiRequest().withName(string);
            CreateRestApiResult createRestApiResult = this.apiGateway.createRestApi(createRestApiRequest);
            return createRestApiResult;
        }
        finally {
            AWS.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putMethod(String string, String string2, String string3) {
        try {
            PutMethodRequest putMethodRequest = new PutMethodRequest().withHttpMethod("ANY").withAuthorizationType(this.isBlank(string3) ? "NONE" : "CUSTOM").withAuthorizerId(this.isBlank(string3) ? null : string3).withRestApiId(string).withResourceId(string2);
            this.apiGateway.putMethod(putMethodRequest);
        }
        finally {
            AWS.await();
        }
    }

    private boolean isBlank(String string) {
        return string == null || string.isEmpty();
    }

    private Resource findFirstResource(String string, Function<Resource, Boolean> function) {
        List<Resource> list = this.listResources(string);
        list.sort(Comparator.comparing(Resource::getPath).reversed());
        return AWS.first(list, function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Resource> listResources(String string) {
        try {
            GetResourcesRequest getResourcesRequest = new GetResourcesRequest().withRestApiId(string).withLimit(Integer.valueOf(500));
            List list = this.apiGateway.getResources(getResourcesRequest).getItems();
            return list;
        }
        finally {
            AWS.await();
        }
    }

    CreateResourceResult createResourcePath(String string, String string2) {
        String string3 = string2;
        Resource resource2 = this.findFirstResource(string, resource -> string3.contains(resource.getPath()));
        if (resource2.getPath().equals(string2)) {
            return new CreateResourceResult().withId(resource2.getId()).withParentId(resource2.getParentId()).withPath(resource2.getPath()).withPathPart(resource2.getPathPart()).withResourceMethods(resource2.getResourceMethods());
        }
        if (!resource2.getPath().equals("/")) {
            string2 = string2.replace(resource2.getPath(), "");
        }
        String[] stringArray = string2.replaceFirst("/$", "").replaceFirst("^/", "").split("/");
        String string4 = resource2.getId();
        CreateResourceResult createResourceResult = null;
        for (String string5 : stringArray) {
            createResourceResult = this.createResource(string4, string, string5);
            string4 = createResourceResult.getId();
        }
        return createResourceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateResourceResult createResource(String string, String string2, String string3) {
        try {
            CreateResourceRequest createResourceRequest = new CreateResourceRequest().withParentId(string).withRestApiId(string2).withPathPart(string3);
            CreateResourceResult createResourceResult = this.apiGateway.createResource(createResourceRequest);
            return createResourceResult;
        }
        finally {
            AWS.await();
        }
    }

    void deployFunction(String string) {
        try {
            CreateDeploymentRequest createDeploymentRequest = new CreateDeploymentRequest().withRestApiId(string).withStageName("Production");
            this.apiGateway.createDeployment(createDeploymentRequest);
        }
        finally {
            AWS.await();
        }
    }

    private static <T> T first(Iterable<T> iterable, Function<T, Boolean> function) {
        for (T t : iterable) {
            if (!function.apply(t).booleanValue()) continue;
            return t;
        }
        return null;
    }

    private static void await() {
        try {
            Thread.sleep(700L);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }
}

