/*
 * Decompiled with CFR 0.152.
 */
package lambdify.mojo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import lambdify.mojo.AWSMojo;
import lambdify.mojo.ZipPackager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="package", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class LambdaPackagerMojo
extends AWSMojo {
    @Parameter(defaultValue="${project}", required=true)
    MavenProject project;
    @Parameter(defaultValue="true", required=true)
    Boolean enabled;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.jar", required=true)
    String jarFileName;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.zip", required=true)
    String zipFileName;
    @Parameter(required=true)
    String handler;

    @Override
    protected void run() throws Exception {
        this.checkIfClassExists(this.handler);
        File file = this.generatePackageFile();
        this.getLog().info((CharSequence)("Generated AWS Lambda package: " + file));
    }

    private void checkIfClassExists(String string) throws MojoFailureException {
        try {
            this.getLog().info((CharSequence)("Checking handler class '" + string + "'..."));
            URLClassLoader uRLClassLoader = new URLClassLoader(this.getClassPathFor(this.jarFileName), ((Object)((Object)this)).getClass().getClassLoader());
            uRLClassLoader.loadClass(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MojoFailureException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MojoFailureException("The specified class does not exists: " + string, (Throwable)classNotFoundException);
        }
    }

    private URL[] getClassPathFor(String string) throws MalformedURLException {
        int n = this.project.getArtifacts().size();
        URL[] uRLArray = new URL[n + 1];
        int n2 = 1;
        for (Artifact artifact : this.project.getArtifacts()) {
            uRLArray[n2++] = artifact.getFile().toURI().toURL();
        }
        uRLArray[0] = new File(string).toURI().toURL();
        return uRLArray;
    }

    private File generatePackageFile() throws MojoExecutionException {
        try (ZipPackager zipPackager = new ZipPackager(this.zipFileName);){
            zipPackager.copyDependenciesToZip(this.project);
            zipPackager.copyFilesFromJarToZip(this.jarFileName);
        }
        return new File(this.zipFileName);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }
}

